/* This ddefit95.h - it contains function prototypes and structures used for controlling the 
   fitting and simulation threads of DDEfit.   */


//#include "inverse.h"
#include <windows.h>
#ifndef MATRIX_HEADER_IN
#include "matrix.h"
#endif
#ifndef SPLINE_HEADER_IN
#include "spline.h"
#endif
#ifndef DDEFIT_HEADER_IN
#define DDEFIT_HEADER_IN
/** bit field flags.......... **/
#define UNBOUND 0
#define INCREASING 1
#define DECREASING 2
#define B_BELOW 4
#define B_ABOVE 8
#define ORIGIN 16
#define RE1 32
#define FIXED 64

#define NO_STATS 0
#define STDEV 1
#define ABSOLUTEDEV 2
#define MEANGRAD 4
#define MEANFREQ 8
#define ACF 16
#define MAXSTAT 16

/* If more stats flags are added then the flag with largest value must
   replace ABSOLUTEDEV in initddefit_control() in ddefit.c */

#define MAX_CO 200
#define MAX_FUNC 50
#define MAX_VAR 1000
typedef struct
{ double y0,y1;} y0y1type;

typedef struct
{ float x,y;} xytype;

typedef struct
{ int win,cur;} wctype;

typedef struct
{ double x0,x1;} x0x1type;

typedef struct
{ int method,   // The method used to fit each replicate
      error,    // The error model to use, 0 normal, 1 Poisson, 2 Gamma
      parametric, // Set to 0 for non-parametric 1 for parametric
      lumped,     // Set to 0 to treat each state variable separately, 1 to lump them all
      iocontrol,  // 0 no data i/o; 1 write rep data to file; 2 read rep data from file
      reps,       // number of b.s. replicates to perform
      nextra,     // number of extra state variables to introduce into b.s. rep data
      *exloc,     // which fitted variable the jth extra variable will belong to in the output.
      *ignore,    // set ignore[i]=1 if fit variable i to be ignored in SS calculation
      restarts[3],// number of bootstrap restarts to perform on 1st, 2nd and subsequent reps.  
      carry_p,    // set to 1 to carry parameter vector from one fit to next, 0 not to.
      n_start_files; // number of starting parameter sets to use (1 file for each.
  char *fdname,   // data file name
       *fpname,   // parameter file name (always written to when bootstrapping)
       *SSname,   // RSS file name 
       **start_file; // array of files containing starting values for bootstrapping
  double missing, // the number which will code for missing data 
         **extra; // The array containing the extra data. 
} bsctype; // bootstrapping control structure 


typedef struct   

{ int n_uf,     // number of unknown functions
      n_uc,     // number of unknown coeffs
      n_c,      // number of fixed coeffs
      n_s,      // number of state variables  
      n_hv,     // number of history variables
      n_lag,    // lag pointers per history variable
      n_sw,     // number of switches
      hbsize,   // history buffer size
      *ufdf,    // array of (max) degrees of freedom for u.f.s
      n_dis,    // number of display variables
      *distos,  // distos[i] is state var for display var i.
      n_fit,    // number of fit variables 
      *fitdv;   // fitdv[i] is 0 if there is no data for this display variable
  double *c,    // array of fixed coeffs
         t0,    // integration start time
         t1,    // integration stop time
         dt,    // output timestep
         tol,   // integration tolerance 
         **ufx, // ufx[i] is x vector for ith uf
         *p,    // the parameter vector
         noise; // standard deviation of normal errors to add to o/p
  HWND   parent; // the window to which the thread sends messages
} simulation_control_type;

typedef struct // structure to contain bootstrap replicate diagnostics
{ int *iterate, // iterate[i] is iterate of bootstrap rep. proccess at which ith minimum found
      *mult,    // mult[i] is number of times minima i revisited
      n,       // total number of distinct minima discovered
      size,    // current array lengths
      on;      // indicates that diagnostics are required/available
  matrix *p,    // p[i] is param. vector for ith minimum
         *e;    // approx error vector for ith minimum
  double *f;     // value of ith minimum    
} bsr_diagnostics_type;


typedef struct // structure controlling fitting and trials

{ int 
      fitmethod, // fitting method to use
      error,     // mean variance relationship 0 - const var.; 1 var propto mean; 2 const CV
	  gcv_method, // gcv method : 0 - Newton , 1 - fast grid search search, 2 - slow grid search
      get_sp,    // estimate smoothing parameters if non- negative
      bsr_reps,  // number of bootstrap restarting replicates
      trial,    // used to flag that a trial not a fit is required!
      n_uf,     // number of unknown functions
      n_uc,     // number of unknown coeffs
      n_c,      // number of fixed coeffs
      n_s,      // number of state variables  
      n_hv,     // number of history variables
      n_lag,    // lag pointers per history variable
      n_sw,     // number of switches
      n_fit,    // number of fit variables (i.e. state variables with data)
      n_st,     // number of sampling times
      n_p,      // total numer of unknown parameters
      n,        // total number of data to fit - n=dim(w)=dim(y)
      stats,    // contains flags for extra statistics
      hbsize,   // history buffer size
      *ufdf,    // array of (max) degrees of freedom for u.f.s
      *uftype,  // type of the u.f.
      *uctype,  // type of u.c.
      n_dis,    // number of display variables
      *raw_n,   // raw_n[i] is number of points in raw[i], for plotting
      *index,   // index[i] is state variable for column i
      *distos,  // distos[i] is state var for display var i.
      *stodis,  // stodis[i] is display variable for state var i (-1 for none)
      *fitdv,   // fitdv[i] is 0 if there is no data for this display variable
      *yts;     // yts[i] returns the state variable corresponding to the ith (non-time) element
                // of the data file read row-wise - an entry of -1 signals no raw data. See
                // readin() or F() for further details.
  double edf,       // estimated degrees of freedom
	     *c,    // array of fixed coeffs
         t0,    // integration start time
 // NOT NEEDED? t1,    // integration stop time
         dout,  // output timestep
         dt,    // initial timestep
         tol,   // integration tolerance 
         **ufx, // ufx[i] is x vector for ith uf
         *uflb, // lower bound of u.f. (if any)
         *ufub, // upper bound of u.f. (if any)
         *ufsp, // smoothing parameters for uf's (-ve => estimate!)
         *ufspmax, // upper bound on smoothing parameters <=0 for no upper bound
         *uclb, // lower bound of u.c. (if any)
         *ucub, // upper bound of u.c. (if any) 
         *p,    // the parameter vector
         **Vp,   // the estimated covariance matrix of the parameters
         *w,    // the weight vector
         *y,    //the data vector 
         *f,    // the fitted value vector - filled in by the fitting thread only
         *ts,   // the sampling times
         *wstats, // weights to give to additional statistics being fitted       
        *re_vmax, // re_vmax[i] is maximum variance for ith random effect term 
       **smooth;// when gradient fitting this contains smoothed data
  xytype **raw;   // raw data series for fitting (in format for display)
  char *dfile,  // data file name (for data being fitted)
       *wfile;  // weight file name (corresponding to data being fitted)     
  HWND   parent; // the window to which the thread sends messages
  bsctype bsc;  // structure containing information for bootstrapping
} fit_control_type;

typedef struct  // structure used to post o/p from work threads to GUI 
// typically created by a work thread and destroyed by GUI thread after use

{ int n_disp,        // number of variables to display
      n_t,           // number of times at which display occurs
      max_n,         // maximum n_t allowed for when display initialized
      *distos;       // state variable corresponding to display variable i
  double *t,         // array of times
         ** display, // display[i] is array of ith display variable
         *ufxmin,    // minimum argument with which uf called
         *ufxmax;    // max argument with which uf called

} display_data_op_type;


typedef struct // structure used to post fit information to the GUI
// typically created by a fit thread and destroyed by GUI after reading.
{ double F,    // objective
         dF;   // change in objective
  int cons;    // number of active constraints
} status_op_type;

typedef struct    //Structure for user definition of fit 
{ int no_windows, // number of graphics output windows
      gradfit,    // set to one to use gradient matching, 0 otherwise
      ppnoise,    // was used as part of estimation of proces errors in method that should be removed!
      *lines,     // lines[i] is number of display variables in window i
      no_uc,      // number of unknown coeffs
      no_uf,      // number of unknown functions
      no_c,       // number of known coeffs
      no_hv,      // number of history variables 
      no_s,       // number of state variables
      no_fit,     // number of fit variables  
      no_sw,      // number of switches 
      rows,       // number of rows of input file to read, if less than all
      *index,     // index[i] is state variable that column i is modelling 
      *ufnsp,     // ufnsp[i] is number of smooth params to try if gridsearching
      *ufdf,      // ufdf[i] is number of parameters of ith uf
      *uftype,    // uftype[i] stores constraint flags for uf i
      *uctype,    // uctype[i] store constraint flags for uc i
      nlag,       // maximum number of lag pointers required for history variables
      statistics, // contains flags specifying extra statistics to fit 
      *rawcount,  // don't know
      fitmethod,  // optimization method to use 
      errors,     // error model to assume
      gcvmethod,  // gcv method to use
      discrete,   // set to 1 for a discrete time model and set to 0 for continuous time
      bsr_reps;   // number of bootstrap restart replicates for fitting 0 => none!!
  long hbsize;    // length of history buffer
  wctype *windex; // window and curve index info for state variable 
  double *uco,    // uco[i] is initial value of uc(i)
           *c,    // c[i] is ith fixed parameter
        *uft0,    // uft0[i] is lowest t value for uf(i,t)
        *uft1,    // uft1[i] is highest t value for uf(i,t)
        *uclb,    // uclb[i] is lower bound on uc(i) (if set to be bounded below)
        *ucub,    // ucub[i] is upper bound on uc(i) (if set to be bounded above)
        *uflb,    // uflb[i] is lower bound on uf(i,t) (if set to be bounded below)
        *ufub,    // ufub[i] is upper bound on uf(i,t) (if set to be bounded above)
      *wstats,    // wstats[S_NAME] is weight to give matching statistic with flag S_NAME
        *ufsp,    // ufsp[i] is smoothing param for ith uf - any -ve => autoselelct
       *ufsp0,    // lower bound on ith smoothing parameter when grid-searching
       *ufdsp,    // grid step for ith smoothing parameter when grid searching
     *ufspmax,    // upper bound on ith smoothing parameter 
      *revmax,    // maximum variance for random effect uf 
	       t0,    // user defines as integration start - altered later to display start 
	     dout,    // default output timestep for display variables
           t1,    // default end-time when simulating
          tol,    // integration tolerance
           dt,    // initial timestep
	     int0,    // eventually holds integration start time 
	   biglag;    // this will hold the largest lag in the model - needed for gradfit 
  char *dfile,    // data file name
       *wfile,    // weight file name
      **label,    // label[i] is the name for the ith state variable
      **cname,    // cname[i] is the name of the ith unknown coefficient
      **wname;    // wname[i] is the name for the ith window
  xytype **raw;   // storage for fit curves - needed for gradient fitting (if re-instated!)
  y0y1type *range; // y range for each window 
} ddefit_control;

extern double (*splp)(int,matrix,matrix,double,double,int,int,int);

/* Macros for use in fitting unknown functions in dde models */
/* uf is a macro for getting value of unknown function no. at x */
#define uf(no,x) (*splp)(no,null_mat,null_mat,x,0.0,1,0,0)
/* guf is macro for obtaining gradient of unknown function no. at x */
#define guf(no,x) (*splp)(no,null_mat,null_mat,x,0.0,2,0,0)
/* iuf is macro for obtaining integral of unknown function no. from x0 to x1*/
#define iuf(no,x0,x1) (*splp)(no,null_mat,null_mat,x0,x1,0,0,0)
/* The following macro is used for referencing unknown coeffs in dde fitting */
#define uc(no) c[-(no)-1]


ddefit_control initddefit_control(int maxco,int maxfunc,int maxvar);
void inboot(bsctype *bsc);
void bscdefaults(int n_fit,bsctype *bsc);
void Jacobian(int (*F)(matrix,matrix,matrix,matrix,matrix,void*,int,double),
     matrix D,matrix J,matrix a,matrix dav,fit_control_type *fc,matrix f,double tol_factor);
void G(matrix f,matrix J,matrix D,matrix a,matrix da,void *fc,int getJ,double tol_factor);
double inuf(int i, double t);
void initfit(ddefit_control *dfc);
void freeddefit_control(ddefit_control dfc);
void outputresults(matrix a,matrix afix,matrix CoA,matrix Y,matrix f);
int statistics(int statype,matrix y,fit_control_type *fc,double **res);
void getdifferrors(matrix f,matrix J,matrix a,fit_control_type *fc,double h,double A,
int i,double *df,double *db,double *dc,double *Cf,double *Cb,double *Cp,double *p);
double audituf(int no,matrix x,matrix y,double x0,double x1,
               int mode,int resetx,int resety);
void newoutput(void);
void forceoutput(matrix a,matrix min,matrix max);
void simforceout(void);
double ndev(void);
double SFTPower(matrix t,matrix h,matrix *p);
double meanf(matrix y,matrix t);
int getno(FILE *f,double *x);
void outputfit(fit_control_type *fc,char *name);
void output_r2(fit_control_type *fc,char *name, double dferr);
double *setupcoeffs(ddefit_control *d,int create);
void simulate(HANDLE signal,ddefit_control *dfc,double *c);
void readin(matrix *y,matrix *w,fit_control_type *fc);
void setupunknowns(fit_control_type *fc,matrix *S,int *off,matrix *A,matrix *Af,
                   matrix *b,matrix *a);
void trial(HANDLE signal,matrix y,matrix w,matrix f,matrix a,matrix afix,
           int gradfit,matrix *A,matrix *b);
void taper(matrix afix,matrix w,matrix w1,double c,long leader);
double pvspliner(int no_his,int no_uf,matrix x,matrix y,double t,int mode,
       int reset);
double pvscaller(int no,double t,int markno);
double pgcaller(int no,double t,int markno);
void setupgradfit(ddefit_control *dfc,matrix *Y,matrix *W,matrix *Co,matrix *afix);
void gethindex(ddefit_control *dfc,int *hindex);
void fitter(int method,int error,
     int (*F)(matrix, matrix, matrix, matrix, matrix, void*, int, double),
     matrix INF,matrix *Z,matrix f,matrix a,
     fit_control_type *fc,matrix W,matrix S,matrix y,matrix A,matrix Af,matrix b,double ro,
     double *maxviol,int bsreps,double *trinf);
double obs(int i,double s,double t);
double datastore(int n,int stages,double *t,int *index,double *y,int state,double time);
void foutput(double *s,double t);
void simulation(PVOID pvoid);
void fit_thread(PVOID pvoid);
void free_display_data_op_type(display_data_op_type *dd);
void ufsetup(double *uxf,double *ufy,double x0,double x1,int nk,int i);
void free_display_data_op_type(display_data_op_type *dd);
void init_display_data_op_type(display_data_op_type *dd,int nt,int ns,int nuf,int *distos);
void ErrorMessage(char *msg,int fatal);
#endif

