/* ddeq.h : the delay differential equation solving library header file */

//#include "inverse.h"
#ifndef DDE_INCLUDED
#define DDE_INCLUDED
#define FASTHISTORY 1
/* the history buffer calculations can be speeded up at the expence of doubling
   the storage requirement of the buffer - the speed up varies from negligible
   to substantial depending on the nature of the problem. Set FASTHISTORY to 0
   to use the slower version */

typedef struct
{ double **buff,**gbuff,**cbuff,**dbuff,*clock,last_time,first_time;
  long offset,size,no,**lagmarker;
  char **cdset,fast; /* cdset[][] is set to zero when c and d coeffs set */
} histype;

extern double (*ppastvalue)(int,double,int),
	      (*ppastgradient)(int,double,int);

#define round(a) ((a)-floor(a) <0.5 ? (int)floor(a):(int) floor(a)+1)

#define pastvalue(i,t,markno) (*ppastvalue)(i,t,markno)

#define pastgradient(i,t,markno) (*ppastgradient)(i,t,markno)
/***************************************************************************/
/*                       Function Prototypes                               */
/***************************************************************************/
#ifdef SUNC

void switchfunctions();
void map();
void grad();
void storehistory();
void initst();
void output();

/*********************** Integration routines ******************************/

void rk23();
void inithisbuff();
void updatehistory();
double realpastvalue();
double realpastgradient();
double zeropos();
double istep();
void dde();

#else
/************************ User Supplied Routines ***************************/

void switchfunctions(double *sw,double *state,double *coeff,double time);
void map(double *state,double *coeff,double time,int swno);
void grad(double *g,double *s,double *c,double t);
void storehistory(double *his,double *ghis,double *g,double *s,double *c,double t);
void initst(double *s,double *c,double t);
void output(double *s,double t,void *dd,int init);
void statescale(double *scale);
/*********************** Integration routines ******************************/

void rk23(double *state,double *newstate,double *g,double *newg,double *error,
	  double *coeff,int ns,double time,double dt);
void inithisbuff(int nhv,long histsize,int nlag);
void updatehistory(double *g,double *s,double *c,double t);
double realpastvalue(int i,double t,int markno);
double realpastgradient(int i,double t,int markno);
double zeropos(double x1,double x2,double x3,double s1,double s2,double s3);
double istep(double *sw0,double *newsws,double *s0,double *news,double *g,
	     double *newg,double *c,double *err,double t0,double t1,int nsw,
	     int ns,int *flickedswitch);
void dde(double *s,double *c,double t0,double t1,double *dt,double eps,
	 double dout, int ns,int nsw,int nhv,long hbsize,int nlag,int reset,
	 int step);
void ddem(double *s,double *c,double t0,double t1,double *dt,double eps,
	 double dout, int ns,int nsw,int nhv,long hbsize,int nlag,int reset,
	 int step);
int is_model_discrete(int i);
#endif
#endif

extern void (*poutput)(double*,double, void*,int);
