/* qp.h : this is the header file for the quadratic programming unit.
   Last Revision 4/3/00 */

matrix addconQT(matrix *Q,matrix T,matrix a,matrix *u);
void GivensAddconQT(matrix *Q,matrix *T,matrix *a,matrix *s,matrix *c);
matrix delconQT(matrix Q,matrix T,long sth);
void getgk(matrix gk,matrix G,matrix cT,matrix y);
long lagrange(matrix gk,matrix Q,matrix T,matrix G,matrix cT,matrix y,
	      matrix I,matrix delog,matrix Af,int getg);
void updateZGZ(matrix *ZGZ,matrix a);
void deleteconstraint(matrix *ZGZ,matrix gk,matrix pk,matrix *R,matrix G,
matrix cT,matrix Q,matrix *Ac,matrix I,matrix *T,matrix y,long s,long *tk,
int getg,int newR);
void searchdirection(matrix gk,matrix pk,matrix R,matrix G,matrix Q,matrix cT,
     matrix y,long tk,int getg);
int isitdegen(matrix Q,matrix A,long tk);
long step(int coninfile,char *confn,matrix Q,matrix Ain,matrix Af,matrix I,
     matrix pk,matrix y,matrix b,long tk);
void QFHmult(matrix A,matrix u);
void getR(matrix *ZGZ,matrix *R,matrix Q,matrix G,long tk,int Greset,matrix u);
void Rupdate(matrix *ZGZ,matrix *R,matrix s,matrix c);
void getAc(int coninfile,char *confn,matrix Ain,matrix Af,matrix *Ac,matrix I,
	   long tk);
void addconstraint(int coninfile,char *confn,matrix *ZGZ,matrix Ain,matrix Af,
     matrix *Ac,matrix I,matrix *R,matrix *Q,matrix *T,long s,long *tk,int newR);
long feasibility(int coninfile,char *name,matrix Ain,matrix x,matrix b,
     double *maxviol);
double residual(matrix M,matrix p,matrix Y,matrix W);
void QPCLS(matrix *Z,matrix *X, matrix *p, matrix *y,matrix *Ain,matrix *b,matrix *Af,int *active);
void PCLS(matrix *X,matrix *p,matrix *y,matrix *w,matrix *Ain,matrix *b,
          matrix *Af,matrix *H,matrix *S,int *off,double *theta,int m, int *active);
long QP(matrix *ZGZ,matrix *Z,matrix Af,matrix Ain,matrix b,matrix y,matrix G,
	matrix cT,char *confn,int conon,int reset,int coninfile,double *maxviol);
matrix getprojectedgradient(matrix gk,matrix Q,int tk);
void QNupdate(matrix M,matrix W,matrix J,matrix S,matrix s,
	      matrix q,double ro);

int NonLinLS(int (*F)(matrix,matrix,matrix,matrix,matrix,void*,int,double),
              matrix J,matrix *Z,matrix f,matrix a,void *prob_dat,matrix W,matrix S,
              matrix Y,matrix A,matrix Af,matrix b,double ro,double *maxviol,int reset);
int CQN(int (*F)(matrix,matrix,matrix,matrix,matrix,void*,int,double),matrix J,
         matrix *Z,matrix f,matrix a,void *prob_dat,matrix W,matrix S,matrix Y,matrix A,
         matrix Af,matrix b,double ro,double *maxviol,int reset);
int IRLS(int (*F)(matrix,matrix,matrix,matrix,matrix,void*,int,double),
          matrix J,matrix *Z,matrix f,matrix a,void *prob_dat,matrix W,matrix S,
          matrix y,matrix A,matrix Af,matrix b,double ro,double *maxviol,int reset);

void optNLLS(int (*F)(matrix,matrix,matrix,matrix,matrix,void*,int,double),
               matrix J,matrix *Z,matrix f,matrix a,void *prob_dat,matrix W,matrix *S,
               matrix y,matrix A,matrix Af,matrix b,int *off,double *maxviol,
               double *lam,double *lmax, int m,int method);
double brent(int (*F)(matrix,matrix,matrix,matrix,matrix,void*,int,double),matrix ap,
       matrix anew,void *prob_dat,matrix fdum,matrix J,matrix G,matrix Y,matrix W,
       matrix S,matrix Q,matrix A,matrix Af, matrix I,matrix bc,matrix pk,
       matrix gk,double ro,long tk,int *gotone, long *sc,double f0,double tol);

int F(matrix f,matrix J,matrix D,matrix a,matrix da,void *problem_data,int getJ,double tol_factor);
double objective(int (*F)(matrix,matrix,matrix,matrix,matrix,void*,int,double),
	    matrix f,matrix J,matrix da,matrix a,void *prob_dat,matrix G,matrix Y,
		 matrix W,matrix S,matrix Q,matrix gk,double ro,double lam,
		 long tk,int getGJ,int *minimum);

void NonLindirection(matrix Q,matrix J,matrix W,matrix S,matrix M,matrix f,
      matrix Y,matrix p,matrix pk,double ro,double lam,long tk,int QNcorr);



/* A global data structure for exporting information from this module for
   output by other modules (possibly not to the console) */
typedef struct
{ long constraints;
  double obj, obj_change;
  int converged;
} qpoutdatatype;
