/* spline.h: header file for the spline function library. */
#ifndef SPLINE_HEADER_IN
#define SPLINE_HEADER_IN
#ifndef MATRIX_HEADER_IN
#include "matrix.h"
#endif
typedef struct
{ double Rni[2][2];} Ru;

typedef struct
{ double Ri[3][2];} Rv;

double b0(double x0,double x1,double x);
double b1(double x0,double x1,double x);
double d0(double x0,double x1,double x);
double d1(double x0,double x1,double x);
double db0(double x0,double x1,double x);
double db1(double x0,double x1,double x);
double dd0(double x0,double x1,double x);
double dd1(double x0,double x1,double x);
double intb0(double x0,double x1,double a,double b);
double intb1(double x0,double x1,double a,double b);
double intd0(double x0,double x1,double a,double b);
double intd1(double x0,double x1,double a,double b);
matrix getD(matrix h,int nak);
double bsbf(int m,double *k,double x,int i,int n);
int bsmap(double *b,double *k,double x,int n);
void rkmap(matrix k,matrix c, double x);
void tmap(matrix tm,matrix tgm,matrix t,double time,int kill);
void getHBH(matrix *HBH,matrix h,int nak,int rescale);
void getSmooth(matrix *S,matrix x,int rescale);
void createA(matrix D,matrix *A,matrix h,int up,int pos);
double spline(matrix x,matrix p,matrix g,double z);
double gspline(matrix x,matrix p,matrix g,double z);
void grad_limit(matrix x,matrix y,matrix g,double lim);
void hyman_filter(matrix x,matrix a,matrix b);
double spl(int no,matrix x,matrix y,double x0,double x1,int mode,int resetx
	   ,int resety);
void splcoeffs(matrix x,matrix a,matrix b,matrix c,matrix d);
void poscon(matrix *A,matrix *b,matrix x,long nop,int perknot);
void imap(matrix im,matrix t,double a,double b,int kill);
matrix quadcon(long n,int type,int rescale);
void GetInf(matrix x,matrix W,matrix A,double lam);
void ss_setup(double **ub,double **lb,double *x,double *h,double *w,long n);
void ss_setupstore(long n,double ***ub,double ***lb,Ru **U,Rv **V,double **a,
		double **b,double **c,double **d,double **TrA,double **Wy,
		double **h,double **ci);
void QTz(long i,long j,double c,double s,double *Wy);
void givens(double a,double b,double *c,double *s);
double GCV(double p,double **ub,double **lb,Ru *U,Rv *V,double *TrA,
	   double *Wy,double *h,double *ci,double *w,double *x,double *y,
	   double sig2,long n,int method);
double ss_minimiser(double **ub,double **lb,Ru *U,Rv *V,double *TrA,double *Wy,
		 double *h,double *ci,double *w,double *x,double *y,
		 double sig2,long n,int method);
void ss_coeffs(double **lb,double *a,double *b,double *c,double *d,double *h,
		  double *y,double *w,double *Wy,long n);
double polyspl(double xx,double *a,double *b,double *c,double *d,double *x,long i);
double fitss_array(double lam,long n,double *x,double *y,double *w,double **a,double **b,		 double **c,double **d,double **ci,int method);
double ss_fit(matrix x,matrix y,matrix w,matrix a,matrix b,matrix c,matrix d,
	    int method,int justa);
void ss_freestore(long n,double ***ub,double ***lb,Ru **U,Rv **V,double **TrA,
		  double **Wy,double **h);

#endif
