/* Copyright Simon Wood and Satan 1991-2002.
   
   (Only kidding. Satan didn't actually do any of the work or contribute any useful ideas
   although he did kindly offer to write the paper provided he was first author.) 
   
   This is mostly code for the GUI for DDEfit.

*/

/* Copyright (C) 1991-2002 Simon N. Wood  snw@st-and.ac.uk

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License   
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
(www.gnu.org/copyleft/gpl.html)

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
USA.*/

#define TITLE "DDEfit 0.504 (c) Simon Wood 1991-2002"

#define INCL_WIN
#define INCL_WINWINDOWMGR
#define INCL_GPI
#define INCL_WINDIALOGS
#define INCL_WINBUTTONS
#define INCL_WINENTRYFIELDS
#define INCL_GPIPRIMITIVES
#define INCL_DOS
#define INCL_DOSPROCESS
#define STRICT
#include <windows.h>
#include <process.h>
#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include "matrix.h"
#include "ddeq.h"
#include "ddefit95.h"
#include "spline.h"
#include "w95dde.h"

#define APPFONT "Arial"
#define FONTSIZE 80
#define MoveTo(hdc,x,y) MoveToEx(hdc,x,y,NULL)


extern void (*ddep)(); /* this declares a pointer to a function which will be used, either for the 
                   dde() function from ddeq.c, or for the ddem() function from map.c,
                   depending on the type of model to be fitted */

short stop_the_fit=0; // used for signalling to the other thread that it should stop

void ErrorMessage(char *msg,int fatal)

{  static int first=1;
   FILE *f;
   HWND hwnd;char *title;
   if (first) 
   { first=0;
     f=fopen("ddefit.err","wt");
     fclose(f);
   }  
   
   hwnd=NULL;
   if (fatal) title="Fatal Error in DDEFIT";else
   title="Error in DDEFIT";
   if (fatal>-1)
   MessageBox(hwnd,msg,title,MB_OK|MB_ICONSTOP);
   else 
   { f=fopen("ddefit.err","at");
     fprintf(f,"%s\n",msg);
     fclose(f);
   }   
   if (fatal==1) exit(-1);
}

int WarningQuery(char *msg)

/* asks a yes/no question and returns 1 on yes, 0 otherwise */

{ 
  if (MessageBox(NULL,(LPCTSTR)msg,"DDEFIT Warning",MB_YESNO|MB_ICONSTOP)==IDYES)
  return(1); else return(0);

}






void setscale(min, max, dx, n, lo, hi) double min,max,dx,*lo,*hi;int *n;

/* Service routine for function scale(); */

{ if (min*max<0.0)
  { *n = (int)ceil(-min/dx) + (int)ceil(max/dx);
    *lo = -dx*ceil(-min/dx);*hi=dx*ceil(max/dx);
  } else if (max<0.0)
  { *n= (int)ceil((max-min)/dx);
    *lo= -dx*ceil(-min/dx);*hi=-dx*floor(-max/dx);
  }
  else
  { *n= (int)ceil((max-min)/dx);
    *lo= dx*floor(min/dx);*hi=dx*ceil(max/dx);
  }
  if (*hi - *lo - *n * dx >0.1*dx ) (*n)++;
}

void compressbuffer(winplotype *w)

/* compresses the line data for a window - if this
   does not achieve sufficient reduction in storage space then an attempt
   is made to expand the data area */

{ int i,j,k,peak;
  k=0;
  for (i=0;i<w->n;i++)
  { if ((!i)||(i==w->n-1)) peak=1;
    else peak=0;  // check that a peak won't get wiped
    if ((i%2)&&(!peak))
    for (j=0;j<w->nvar;j++) // checks if any curve has a turning point
    { if ((w->data[j][i].y- w->data[j][i-1].y)*(w->data[j][i+1].y-w->data[j][i].y)<0.0)
      peak=1;
    }
    if (!(i%2)||peak)
    { for (j=0;j<w->nvar;j++)
      w->data[j][k]=w->data[j][i];
      k++;
    }
  }
  w->n=k;
  if (w->n>3*w->datasize/4) // not enough compression - try expansion
  { for (i=0;i<w->nvar;i++)
    w->data[i]=realloc(w->data[i],sizeof(xytype)*(w->datasize+200));
    if (w->data[w->nvar-1])
    w->datasize+=200;
    else ErrorMessage("out of memory in compressbuffer",1);
  }  
}

void scale(min,max,x0,dx,nx,exx)
double min,max, /* original limits */
       *x0,*dx,*exx; /* start of scale increment number of ticks and exponent */
int *nx;

/* code for a pleasing scale. min and max are the limits of some data.
   x0 will contain the lower limit of some rounded scale, dx the increment,
   nx the number of increments to the top of the scale, and exx the power of
   ten by which all numbers should be multiplied. The routine requires
   setscale(). */

{ double range,lo,hi,dxt[4]={0.1,0.2,0.5,1.0},f,fmin=0.0;
  int n,i;
  range=max-min;
  if (range>0) *exx=floor(log10(range));
  range /=pow(10.0,*exx);
  if (range>=10.0) { range/=10.0;*exx += 1.0;}
  if (range<0.5) { *exx -=1.0;}
  min /= pow(10.0,*exx);
  max /= pow(10.0,*exx);
  for (i=0;i<4;i++)
  { setscale(min,max,dxt[i],&n,&lo,&hi);
    f=(n-6.0)*(n-6.0);
    if ((!i)||(f<fmin))
    { fmin=f;*dx=dxt[i];*nx=n;*x0=lo;}
  }
  if (fabs(*exx)<4)
  { f=pow(10,*exx);
    *dx *=f;*x0 *=f;
    *exx=0.0;
  }  
}


void tplot(HDC hdc,HWND hwnd,winplotype *w,int draw)

/* Plots continuous curves for data in w->data (plots w->data[j][i].y against w->data[j][i].x)
   If w->plot_raw is non-zero then any data in w->raw[j] are also plotted as discrete points in the 
   same colour as the curve from  w->data[j].
   
*/

{ int i,di,j,xi,xf,yi,yf,db,cxchar,cychar;
  static double x,y;
  static int first=1;
  POINT p,q;
  RECT swp;
  SIZE size;
  static HPEN pen[8];
  if (first)
  { first=0;
    pen[0]=CreatePen(PS_SOLID,1,RGB(0,0,0));
    pen[1]=CreatePen(PS_SOLID,1,RGB(255,0,0));
    pen[2]=CreatePen(PS_SOLID,1,RGB(0,255,0));
    pen[3]=CreatePen(PS_SOLID,1,RGB(0,0,255));
    pen[4]=CreatePen(PS_SOLID,1,RGB(127,127,0));
    pen[5]=CreatePen(PS_SOLID,1,RGB(127,0,127));
    pen[6]=CreatePen(PS_SOLID,1,RGB(0,127,127));
    pen[7]=CreatePen(PS_SOLID,1,RGB(255,64,64));
  }
  GetTextExtentPoint32(hdc,"M",strlen("M"),&size);
  cxchar=size.cx;cychar=size.cy;
  /* calculations relating to the graph axes */
  if (w->newaxes)
  { scale(w->y0,w->y1,&(w->y0),&(w->dy),&(w->ny),&(w->exy));

    scale(w->x0,w->x1,&(w->x0),&(w->dx),&(w->nx),&(w->exx));

    sprintf(w->lolaby,"%g",w->y0);
    GetTextExtentPoint32(hdc,w->lolaby,strlen(w->lolaby),&size);
    w->offset=size.cx;
    sprintf(w->hilaby,"%g",w->y0+w->ny*w->dy);
    GetTextExtentPoint32(hdc,w->hilaby,strlen(w->hilaby),&size);
    if (size.cx>w->offset) w->offset=size.cx;
    sprintf(w->exlaby,"e%d",(int)w->exy);
    GetTextExtentPoint32(hdc,w->exlaby,strlen(w->exlaby),&size);
    if (size.cx>w->offset) w->offset=size.cx;
    sprintf(w->lolabx,"%g",w->x0);
    sprintf(w->hilabx,"%g",w->x0+w->nx*w->dx);
    sprintf(w->exlabx,"e%d",(int)w->exx);
    w->y0 *= pow(10.0,w->exy);
    w->dy *= pow(10.0,w->exy);
    w->x0 *= pow(10.0,w->exx);
    w->dx *= pow(10.0,w->exx);
    w->y1=w->y0+w->ny*w->dy;
    w->x1=w->x0+w->nx*w->dx;
  }

  /* calculations relating to actual plot - redo when bounding box changes */

  if (w->newaxes||w->resize)
  { GetClientRect(hwnd, &swp);
    w->llx=swp.left;w->lly=swp.bottom;
    w->urx=swp.right;w->ury=swp.top;
    w->newaxes=w->resize=0;
    /* find dimensions of header */
    w->headwidth=0;
    for (i=0;i<w->nvar;i++)
    { GetTextExtentPoint32(hdc,w->label[i],strlen(w->label[i]),&size);
      j=size.cx;
      if (j>w->headwidth) w->headwidth=j;
    }
    if (w->headwidth)
    { w->headwidth += 20;}

    w->llx+=w->offset + 2*cxchar; // moving graph in from box edge
    w->urx-=(int)(0.5*cxchar);
    /* Make room for header */
    w->headcols = (w->urx-w->llx)/w->headwidth;
    if (w->headcols<1) w->headcols=1;
    w->headrows = w->nvar/w->headcols;
    if (w->nvar%w->headcols) w->headrows++;
    w->ury+=3*w->headrows*cychar/2;
    w->lly-=3*cychar;

    w->width=w->urx-w->llx;w->height=w->ury-w->lly;
    w->sfx=w->width/(w->x1-w->x0);w->sfy=w->height/(w->y1-w->y0);
  }
  if (draw)
  { /* Drawing bounding axes */

    p.x=w->llx;p.y=w->lly;MoveTo(hdc,p.x,p.y);
    p.x=w->urx;LineTo(hdc,p.x,p.y);
    p.y=w->ury;LineTo(hdc,p.x,p.y);
    p.x=w->llx;LineTo(hdc,p.x,p.y);
    p.y=w->lly;LineTo(hdc,p.x,p.y);

    di=w->height/40+1;
    p.y=w->lly;q.y=p.y+di;  /* x axis ticks */
    for (i=1;i<w->nx;i++)
    { p.x=q.x=w->llx+(w->width*i)/w->nx;
      MoveTo(hdc,p.x,p.y);LineTo(hdc,q.x,q.y);
    }
    di=w->width/40+1;
    p.x=w->llx;q.x=p.x+di;   /* y axis ticks */
    for (i=1;i<w->ny;i++)
    { p.y=q.y=w->lly+(w->height*i)/w->ny;
      MoveTo(hdc,p.x,p.y);LineTo(hdc,q.x,q.y);
    }
    /* y axis labels */
    GetTextExtentPoint32(hdc,w->hilaby,strlen(w->hilaby),&size);
    p.x=w->llx-size.cx-cxchar/2;p.y=w->ury - cychar/2;
    TextOut(hdc,p.x,p.y,w->hilaby,strlen(w->hilaby));
    if (w->exy!=0.0)
    { GetTextExtentPoint32(hdc,w->exlaby,strlen(w->exlaby),&size);
      p.x=w->llx-size.cx-cxchar/2;p.y=w->ury + cychar/2;
      TextOut(hdc,p.x,p.y,w->exlaby,strlen(w->exlaby));
    }
    GetTextExtentPoint32(hdc,w->lolaby,strlen(w->lolaby),&size);
    p.x=w->llx-size.cx-cxchar/2;p.y=w->lly - cychar/2;
    TextOut(hdc,p.x,p.y,w->lolaby,strlen(w->lolaby));
    /* x axis labels */
    GetTextExtentPoint32(hdc,w->hilabx,strlen(w->hilabx),&size);
    p.x=w->urx-size.cx;p.y=w->lly+ cychar/2;
    TextOut(hdc,p.x,p.y,w->hilabx,strlen(w->hilabx));

    if (w->exx!=0.0)
    { GetTextExtentPoint32(hdc,w->exlabx,strlen(w->exlabx),&size);
      p.x=w->urx-size.cx;p.y=w->lly+5*cychar/4;
      TextOut(hdc,p.x,p.y,w->exlabx,strlen(w->exlabx));
    }
    GetTextExtentPoint32(hdc,w->lolabx,strlen(w->lolabx),&size);
    p.x=w->llx;p.y=w->lly+cychar/2;
    TextOut(hdc,p.x,p.y,w->lolabx,strlen(w->lolabx));

    /* output color code header */
    for (i=0;i<w->nvar;i++)
    { SelectObject(hdc,pen[i%8]);
      p.x=w->llx+(i%w->headcols)*w->headwidth;
      p.y=w->ury-(w->headrows*3*cychar)/2+(3*cychar*(i/w->headcols))/2+cychar/2;
      MoveTo(hdc,p.x,p.y);
      p.x+=15;
      LineTo(hdc,p.x,p.y);
      SelectObject(hdc,pen[0]);
      p.y-= cychar/2;p.x+=3;
      TextOut(hdc,p.x,p.y,w->label[i],strlen(w->label[i]));

    }
    db=w->urx-w->llx+w->lly-w->ury;db/=400;if (!db) db=1;
    for (j=0;j<w->nvar;j++)
    { SelectObject(hdc,pen[j%8]);
      if (w->n) /* move to 1st point */
      { x=(double)w->data[j][0].x;if (x>w->x1) x=w->x1; if (x<w->x0) x=w->x0;
	     xi=(int)((x-w->x0)*w->sfx+w->llx);
	     y=(double)w->data[j][0].y;if (y>w->y1) y=w->y1; if (y<w->y0) y=w->y0;
	     yi=(int)(w->lly+(y-w->y0)*w->sfy);
	     if (yi>w->lly) yi=w->lly; if (yi<w->ury) yi=w->ury;
	     p.y=yi;p.x=xi;
        MoveTo(hdc,p.x,p.y);
      }

      for (i=1;i<w->n;i++) /* drawing line */
      { x=(double)w->data[j][i].x;if (x>w->x1) x=w->x1; if (x<w->x0) x=w->x0;
	     xf=(int)((x-w->x0)*w->sfx+w->llx);
        y=(double)w->data[j][i].y;if (y>w->y1) y=w->y1; if (y<w->y0) y=w->y0;
	     yf=(int)(w->lly+(y-w->y0)*w->sfy);
	     if (yf>w->lly) yf=w->lly; if (yf<w->ury) yf=w->ury;
	     p.y=yf;p.x=xf;
	     LineTo(hdc,p.x,p.y);
      }

      /* Now plot raw data - w->raw[j][i] contains jth x,y points for jth line */
      if (w->plot_raw) 
      for (i=0;i<w->no_raw_points[j];i++)
      { x=(double)w->raw[j][i].x;if (x>w->x1) x=w->x1; if (x<w->x0) x=w->x0;
	     xf=(int)((x-w->x0)*w->sfx+w->llx);xf-=db;
	     if (xf<w->llx) xf=w->llx; if (xf>w->urx) xf=w->urx;
	     y=(double)w->raw[j][i].y;
        if (y>w->y1) y=w->y1; if (y<w->y0) y=w->y0;
	     yf=(int)(w->lly+(y-w->y0)*w->sfy);yf-=db;
	     if (yf>w->lly) yf=w->lly; if (yf<w->ury) yf=w->ury;
	     p.y=yf;p.x=xf;
	     yf+=2*db;xf+=2*db;
	     if (xf<w->llx) xf=w->llx; if (xf>w->urx) xf=w->urx;
	     if (yf>w->lly) yf=w->lly; if (yf<w->ury) yf=w->ury;
	     
        Rectangle(hdc,p.x,p.y,xf,yf);

      }
    }
    SelectObject(hdc,pen[0]);
  } else // its an update only ....
  { for (j=0;j<w->nvar;j++)
    { if (w->n)
      { x=(double)w->data[j][w->n-2].x;
        if (x>w->x1) x=w->x1; if (x<w->x0) x=w->x0;
	     xi=(int)((x-w->x0)*w->sfx+w->llx);
	     y=(double)w->data[j][w->n-2].y;
        if (y>w->y1) y=w->y1; if (y<w->y0) y=w->y0;
	     yi=(int)(w->lly+(y-w->y0)*w->sfy);
	     if (yi<w->lly) yi=w->lly; if (yi>w->ury) yi=w->ury;
        x=(double)w->data[j][w->n-1].x;
        if (x>w->x1) x=w->x1; if (x<w->x0) x=w->x0;
	     xf=(int)((x-w->x0)*w->sfx+w->llx);
	     y=(double)w->data[j][w->n-1].y;
        if (y>w->y1) y=w->y1; if (y<w->y0) y=w->y0;
	     yf=(int)(w->lly+(y-w->y0)*w->sfy);
	     if (yf<w->lly) yf=w->lly; if (yf>w->ury) yf=w->ury;

	     p.y=yi;p.x=xi;q.y=yf;q.x=xf;
	     SelectObject(hdc,pen[j%8]);
	     MoveTo(hdc,p.x,p.y);LineTo(hdc,q.x,q.y);
      }
    }
    SelectObject(hdc,pen[0]);
  }
}

#define EZ_ATTR_BOLD 1
#define EZ_ATTR_ITALIC 2
#define EZ_ATTR_UNDERLINE 4
#define EZ_ATTR_STRIKEOUT 8

HFONT EzCreateFont(HDC hdc, char *szFaceName, int iDeciPtHeight,
                   int iDeciPtWidth, int iAttributes, BOOL fLogRes)
/* Routine for easy loading of trutype fonts, from Petzold (1996)
   "Programming Windows 95" a wonderful book well structured, clear
   and actually useful (and published by Microsoft?!).

   hdc           - handle to current device context
   szFaceName    - string containing typeface name (p. 223 of Petzold)
   iDeciPtHeight - typeface height in 10ths of a point !
   iDeciPtWidth  - set to 0 for default width.
   iAttributes   - Set to 0 or one of the EZ_ATTRibutes defined above
   fLogRes       - set to TRUE to use the logical resolution....
 */

{ FLOAT cxDpi,cyDpi;
  HFONT hFont;
  LOGFONT lf;
  POINT pt;
  TEXTMETRIC tm;

  SaveDC(hdc);

  SetGraphicsMode(hdc, GM_ADVANCED);
  ModifyWorldTransform(hdc,NULL,MWT_IDENTITY);
  SetViewportOrgEx(hdc,0,0,NULL);
  SetWindowOrgEx(hdc,0,0,NULL);

  if (fLogRes)
  { cxDpi=(FLOAT) GetDeviceCaps(hdc,LOGPIXELSX);
    cyDpi=(FLOAT) GetDeviceCaps(hdc,LOGPIXELSY);
  } else
  { cxDpi= (FLOAT) (25.4 * GetDeviceCaps(hdc,HORZRES)/
                    GetDeviceCaps(hdc,HORZSIZE));
    cyDpi= (FLOAT) (25.4 * GetDeviceCaps(hdc,VERTRES)/
                    GetDeviceCaps(hdc,VERTSIZE));
  }
  pt.x=(int)(iDeciPtWidth * cxDpi /72);
  pt.y=(int)(iDeciPtHeight * cyDpi /72);

  DPtoLP(hdc,&pt,1);

  lf.lfHeight = - (int) (fabs(pt.y)/10.0 + 0.5);
  lf.lfWidth = 0;
  lf.lfEscapement = 0;
  lf.lfOrientation = 0;
  lf.lfWeight = iAttributes & EZ_ATTR_BOLD   ? 700 : 0;
  lf.lfItalic = iAttributes & EZ_ATTR_ITALIC ? 1 : 0;
  lf.lfUnderline = iAttributes & EZ_ATTR_UNDERLINE ? 1 : 0;
  lf.lfStrikeOut = iAttributes & EZ_ATTR_STRIKEOUT ? 1 : 0 ;
  lf.lfCharSet =0;
  lf.lfOutPrecision=0;
  lf.lfClipPrecision=0;
  lf.lfQuality=0;
  lf.lfPitchAndFamily=0;

  strcpy(lf.lfFaceName,szFaceName);

  hFont=CreateFontIndirect(&lf);

  if (iDeciPtWidth != 0)
  { hFont=(HFONT) SelectObject(hdc,hFont);
    GetTextMetrics(hdc,&tm);
    DeleteObject(SelectObject(hdc,hFont));
    lf.lfWidth=(int)(tm.tmAveCharWidth*fabs(pt.x)/fabs(pt.y)+0.5);
    hFont=CreateFontIndirect(&lf);
  }
  RestoreDC(hdc,-1);
  return hFont;
}


BOOL CALLBACK RescaleProc (HWND hwnd, UINT msg, WPARAM wParam,
							LPARAM mp2)

{ HWND sib;
  static HWND Parent;
  winplotype *w;
  int i,j;
  static char input[20];
  double y0,y1;
  
  
  switch (msg)
  { case WM_INITDIALOG:
	     Parent=(HWND) mp2;   
         return TRUE;
    case WM_COMMAND:
    w=(winplotype *)GetWindowLong(Parent,GWL_USERDATA); 
	switch (LOWORD(wParam))
	{ case 10 :
	   { //need to get handles for min and max edits and then read them -
	     // check they make sense - if so change them - otherwise apologise and close

	     sib=GetDlgItem(hwnd,40);    //reads min y
	     i=GetWindowTextLength(sib);
         if (i)
	     { GetWindowText(sib,input,i+1);  // UDF: its i+1 in order to read '\0'
	       sscanf(input,"%lf",&y0);
	     } else
	     y0 = w->y0;


	     sib=GetDlgItem(hwnd,41);    //reads max y
	     j=GetWindowTextLength(sib);
         if (j)
	     { GetWindowText(sib,input,j+1);  // UDF: its i+1 in order to read '\0'
	       sscanf(input,"%lf",&y1);
	     } else
	     y1= w->y1;

	     if ((i||j)&&(y0<y1))
	     { w->y1=y1;
	       w->y0=y0;
           w->newaxes=1;
	       w->resize=1;
 	       InvalidateRect(Parent,NULL,FALSE);  /* maybe TRUE */
        }
	    EndDialog(hwnd,0);

      }
	  return TRUE;

	  case 12 :  // double the plotting scale
	   w->y1*=2;
	   w->newaxes=1;
	   w->resize=1;
	   InvalidateRect(Parent,NULL,FALSE);

	   EndDialog(hwnd,0);
	   return TRUE;
	   case 21 :  // double the plotting scale
     
	   w->y1*=0.5;
	   w->newaxes=1;
	   w->resize=1;
	   InvalidateRect(Parent,NULL,FALSE);

	   EndDialog(hwnd,0);
       return TRUE;

	   case 40 : // lower bound

	   return TRUE;

	   case 41 : //upper bound

       return TRUE;

	 }
    break;
  }
  return FALSE ;
}

BOOL CALLBACK ufRescaleProc (HWND hwnd, UINT msg, WPARAM wParam,
							LPARAM mp2)

{ static HWND Parent;
  HWND sib;
  int i,j;
  static char input[20];
  double y0,y1;
  ufwindatatype *wd;
  switch (msg)
  { case WM_INITDIALOG:
    Parent=(HWND) mp2;
	 return TRUE;
    case WM_COMMAND:
    wd=(ufwindatatype *)GetWindowLong(Parent,GWL_USERDATA);
	 switch (LOWORD(wParam))
	 { case 10 :
	   { //need to get handles for min and max edits and then read them -
	     // check they make sense - if so change them - otherwise apologise and close

  	     sib=GetDlgItem(hwnd,40);    //reads min y
	     i=GetWindowTextLength(sib);
        if (i)
	     { GetWindowText(sib,input,i+1);  // UDF: its i+1 in order to read '\0'
	       sscanf(input,"%lf",&y0);
	     } else
	     y0 = wd->y0;


	     sib=GetDlgItem(hwnd,41);    //reads max y
	     j=GetWindowTextLength(sib);
        if (j)
	     { GetWindowText(sib,input,j+1);  // UDF: its i+1 in order to read '\0'
	       sscanf(input,"%lf",&y1);
	     } else
	     y1= wd->y1;

	     if ((i||j)&&(y0<y1))
	     { wd->y1=y1;
	       wd->y0=y0;

	       InvalidateRect(Parent,NULL,FALSE);  /* maybe TRUE */
        }

	     EndDialog(hwnd,0);

      }
	   return TRUE;

	   case 12 :  // double the plotting scale


      if (wd->y0==0.0) wd->y1=2.0*wd->y1*wd->ym;else
	   if (wd->y1==0.0) wd->y0=2.0*wd->y0*wd->ym;else
	   { y0=(wd->y0+wd->y1)*0.5*wd->ym;y1=(wd->y1-wd->y0)*wd->ym;
	     wd->y0=y0-y1;wd->y1=y0+y1;
	   }

	   InvalidateRect(Parent,NULL,FALSE);

	   EndDialog(hwnd,0);
	   return TRUE;
	   case 21 :  // halve the plotting scale

      if (wd->y0==0.0) wd->y1=0.5*wd->y1*wd->ym;else
	   if (wd->y1==0.0) wd->y0=0.5*wd->y0*wd->ym;else
	   { y0=(wd->y0+wd->y1)*0.5*wd->ym;y1=(wd->y1-wd->y0)*wd->ym/4;
	     wd->y0=y0-y1;wd->y1=y0+y1;
	   }

	   InvalidateRect(Parent,NULL,FALSE);

	   EndDialog(hwnd,0);
           return TRUE;

	   case 40 : // lower bound

	   return TRUE;

	   case 41 : //upper bound

           return TRUE;

	 }
    break;
  }
  return FALSE ;
}




LRESULT CALLBACK IntParamProc (HWND hwnd, UINT message, UINT wParam,
							  LONG lParam)

{ static HWND Parent; 
  static double t,*(tar[4]);
  int i,j;
  char input[50];
  HWND sib;
  parent_win_data_type *wd;
  switch (message)
  { case WM_INITDIALOG:
	     Parent=(HWND)lParam; // handle to parent window 
         wd=(parent_win_data_type *)GetWindowLong(Parent,GWL_USERDATA);
         tar[0]=&(wd->simdt);tar[3]=&(wd->simnoise);tar[2]=&(wd->simt1);
         tar[1]=&(wd->simt0);
         for (i=0;i<4;i++)
	      { sib=GetDlgItem(hwnd,101+i); // dt box
	        sprintf(input,"%g",*(tar[i]));
	        SetWindowText(sib,input);
         }
	      sib=GetDlgItem(hwnd,105);
	      SetFocus(sib);
	      return TRUE;

    case WM_COMMAND:
	      switch (wParam)
	      { case 101 :     // editing
	        return TRUE;
	        case 102 :     // editing
	        return TRUE;
            case 103 :     // editing
	        return TRUE;
	        case 104 :     // editing
	        return TRUE;
	        case 105 :     // finished
            for (i=0;i<4;i++)
	        { sib=GetDlgItem(hwnd,101+i);    //dt box
	          j=GetWindowTextLength(sib);
              if (j)
	          { GetWindowText(sib,input,j+1);  // UDF: its i+1 in order to read '\0'
		        sscanf(input,"%lf",&t);
                *(tar[i])=t;
		      }
              if (is_model_discrete(0)) *(tar[0])=1.0;
		    }
		    EndDialog(hwnd,0);
		  }
	      return TRUE;
	
  }
  return FALSE;
}




void GetChildRect(HWND hwnd,RECT *rect)

/* gets rect of window with handle hwnd, relative to its parent */

{ RECT rectp;
  POINT p;
  GetClientRect(GetParent(hwnd),&rectp);
  GetWindowRect(hwnd,rect);
  p.x=rect->left;p.y=rect->top;
  ScreenToClient(GetParent(hwnd),&p);
  rect->left=p.x;rect->top=p.y;
  p.x=rect->right;p.y=rect->bottom;
  ScreenToClient(GetParent(hwnd),&p);
  rect->right=p.x;rect->bottom=p.y;
} 


LRESULT CALLBACK StatusWndProc (HWND hwnd, UINT msg, WPARAM wParam,LPARAM lParam)

/* handles the status window - which outputs information like number of
   active constraints and the objective function value 
   There are several commands called using WM_COMMAND with LOWORD(wParam) set to:
   1. Parent has updated wd->obj, wd->dobj and/or wd->cons
   2. Set display to 1 column mode
   3. Set display to 2 column mode
   4. Set display to 3 column mode

   The last 3 are used by the parent when auto-arranging to try and get a tidy
   tiling. After using these commands the parent looks in the status windows data 
   for the ideal window dimension information (this wretched interface stuff is sooooooo
   tedious and it's sunny outside at the moment - why am I such a sad git sitting in here 
   writing this stuff that in the great scheme of things makes absolutely no difference 
   to anything? it's not as if the time wouldn't pass anyway.). 

*/

{ PAINTSTRUCT ps;
  TEXTMETRIC tm;
  WINDOWPLACEMENT wp;
  HDC hdc;
  RECT rect,rectw;
  POINTL p;
  status_type *wd; // data for this window
  static HFONT hFont;
  static HINSTANCE hInstance;
  static HWND *hwndb;
  static long cxchar,cychar,space,height,rows,cols,hwndb_on=0;
  static long ww,x0,y0,VSmax,HSmax;
  //static float left,top,right,bottom; // position 
  static SIZE wsize;
  int i,j,k,no_out=3,wh;
  char text[50];
  static char **label,rescale=0,user_sizing=0;
  if (msg!=WM_CREATE) // retrieve the window data
  wd=(status_type *)GetWindowLong(hwnd,GWL_USERDATA);
  switch (msg)
  { case WM_CREATE :   // DON'T Call anything that calls StatusWndProc before wd stored!!!
         hInstance=(HINSTANCE) GetWindowLong(hwnd,GWL_HINSTANCE);
         wd=(status_type *)calloc(1,sizeof(status_type)); // window data
         hdc=BeginPaint(hwnd,&ps);
         hFont=EzCreateFont(hdc,APPFONT,FONTSIZE,0,0,TRUE);
         SelectObject(hdc,hFont);
         GetTextMetrics(hdc,&tm);
         cxchar = (long) tm.tmAveCharWidth;
         cychar = (long) tm.tmHeight + tm.tmExternalLeading;
	     hwndb=(HWND *)calloc((size_t)no_out,sizeof(HWND));
	     label=(char **)calloc((size_t)no_out,sizeof(char *));
	     hwndb_on=1;
	     space=0;
	     x0=0;y0=0;
	     label[0]="F(p)";label[1]="dF";label[2]="Cons";
	     for (i=0;i<no_out;i++)
	     { GetTextExtentPoint32(hdc,label[i],strlen(label[i]),&wsize);
           if (wsize.cx>space) space=wsize.cx;
         }
         GetTextExtentPoint32(hdc,"-0.0000e-00 ",strlen("-0.0000e-00 "),&wsize);
         wsize.cy+=4;wsize.cx+=6;
	     space+=wsize.cx+10;
	     height=9*wsize.cy/8;
         cols=(long)ceil(sqrt(height*no_out/((double) space)));
	     rows=(long)ceil(no_out/((double)cols));
         //cols=1;rows=3;     
         GetWindowRect(GetDesktopWindow(), &rect);
         wd->xmax=rect.right-rect.left;wd->ymax=rect.bottom-rect.top;

	     ww=cols*space+cxchar*2; if (ww>wd->xmax) ww=wd->xmax; /* window width */
	     wh=rows*height+cychar/2;if (wh>wd->ymax) wh=wd->ymax; /* window height */
	     wd->ymax=height*rows+cychar/2;    /* Max y for drawing */
         
	     wd->xmax=space*cols+2*cxchar;                /* Max x for drawing */
	     // now find the width of the window borders
         GetClientRect(hwnd,&rect);
         GetWindowRect(hwnd,&rectw);
         wd->ywedge=rectw.bottom-rectw.top-rect.bottom+rect.top;
         wd->xwedge=rectw.right-rectw.left-rect.right+rect.left; 
         
         wh+=wd->ywedge;
         ww+=wd->xwedge;
	     k=0;
	     for (i=0;i<rows;i++)
	     for (j=0;j<cols;j++)
	     if (k<no_out)  /* setting up edit windows containing parameters */
	     { if (k==0) sprintf(text,"%8.4g",wd->obj);else
	       if (k==1) sprintf(text,"%8.4g",wd->dobj);else
	       if (k==2) sprintf(text,"%ld",wd->cons);
           hwndb[k]=CreateWindow("edit",text,WS_CHILD|WS_VISIBLE|ES_LEFT|WS_BORDER,
	               x0+2*cxchar+space*j,y0+height*i+cychar*3,wsize.cx,
                  wsize.cy,hwnd,(HMENU)(101+k),hInstance,NULL);
           SendMessage(hwndb[k],WM_SETFONT,(WPARAM) hFont,MAKELPARAM(TRUE, 0));
           k++;
	     }

	     EndPaint(hwnd,&ps);
	     
	     GetClientRect(hwnd,&rect);
         // store window data.....
         SetWindowLong(hwnd,GWL_USERDATA,(LONG)wd); 
         SetWindowPos(hwnd,HWND_TOP,0,0,ww,wh,SWP_SHOWWINDOW );
       
         return(0);
    case WM_MOVING: // note that user is moving window
          user_sizing=1;
          return(0);
    case WM_MOVE :
            if (user_sizing) // then tell parent that user has moved window
            { user_sizing=0;
              PostMessage(GetParent(hwnd),WM_COMMAND,(WPARAM)MAKELONG(10,0),(LPARAM)0);
            }    
          return(0);
	case WM_SIZING: // user is resizing window
         user_sizing=1; 
         return(0); 
    case WM_SIZE :
         y0=x0=0; // put top left of display material at top left of visible client
         
          GetWindowRect(hwnd,&rectw);
          i=rectw.bottom-rectw.top-wd->ywedge;
          VSmax=wd->ymax-i;
	      if (VSmax<0) VSmax=0;
	      SetScrollRange(hwnd,SB_VERT,0,VSmax,FALSE);
	      SetScrollPos(hwnd,SB_VERT,0,TRUE);
 
          j=rectw.right-rectw.left-wd->xwedge; 
      	  HSmax=wd->xmax-j;
	      if (HSmax<0) HSmax=0;
          SetScrollRange(hwnd,SB_HORZ,0,HSmax,FALSE);
      	  SetScrollPos(hwnd,SB_HORZ,0,TRUE);  
            
         if (user_sizing) // then tell parent that user has resized the window
         { user_sizing=0;
           PostMessage(GetParent(hwnd),WM_COMMAND,(WPARAM)MAKELONG(10,0),(LPARAM)0);
         }            
	     InvalidateRect(hwnd,NULL,TRUE);
	     return 0;
    
    case WM_PAINT :
         hdc=BeginPaint(hwnd,&ps);
         SelectObject(hdc,hFont);
         GetClientRect(hwnd,&rect);
	     FillRect(hdc,(RECT*)&rect,(HBRUSH)GetStockObject(WHITE_BRUSH));
	     k=0;
	     for (i=0;i<rows;i++)
	     for (j=0;j<cols;j++)
	     if (k<no_out)
	     { if (k==0) sprintf(text,"%8.4g",wd->obj);else
	       if (k==1) sprintf(text,"%8.4g",wd->dobj);else
	       if (k==2) sprintf(text,"%ld",wd->cons);
	       if (hwndb_on)
           MoveWindow(hwndb[k],x0+2*cxchar+space*j,y0+height*i+cychar/2,
                       wsize.cx,wsize.cy,TRUE);
	       p.x=x0+2*cxchar+space*j+wsize.cx+3;
	       p.y=y0+height*i+cychar/2;
	       TextOut(hdc,p.x,p.y,label[k],strlen(label[k]));
	       InvalidateRect(hwndb[k],NULL,TRUE);
	       SetWindowText(hwndb[k],text);
	       k++;
	     }
         SelectObject(hdc,GetStockObject(SYSTEM_FONT));
	     GetWindowPlacement(hwnd,&wp);rect=wp.rcNormalPosition;
         EndPaint(hwnd,&ps);
	     return 0 ;

    case WM_DESTROY: // clear up memory
         free(wd);
         if (hwndb_on) free(hwndb);hwndb_on=0;
         DeleteObject(hFont);
	     return 0 ;
    case WM_COMMAND:
         k=LOWORD(wParam);
         if (k ==1) /* new values for windows */
	     { for (k=0;k<no_out;k++)
	       { if (k==0) sprintf(text,"%8.4g",wd->obj);else
	         if (k==1) sprintf(text,"%8.4g",wd->dobj);else
	         if (k==2) sprintf(text,"%ld",wd->cons);
	         SetWindowText(hwndb[k],text);
	       }
	     } else
         if (k<5&&k>1) /* set to k-1 column mode */
         { cols=k-1;
           rows=4-cols;
           wd->ymax=height*rows+cychar/2;    /* Max y for drawing */
           wd->xmax=space*cols+2*cxchar;     /* Max x for drawing */
         }
         
         return(0);
    case WM_VSCROLL:

	     switch (LOWORD(wParam))
         {          case SB_TOP :y0=0;break;
	                case SB_BOTTOM :y0=VSmax;break;
                    case SB_LINEUP :y0++;break;
	                case SB_LINEDOWN :y0--;break;
	                case SB_PAGEUP :y0+=VSmax/10+1;break;
	                case SB_PAGEDOWN :y0+= -VSmax/10-1;break;
	                case SB_THUMBTRACK :y0= -HIWORD(wParam);break;
	     }
         if (y0<-VSmax) y0=-VSmax;
         if (y0>0) y0=0;
	     SetScrollPos(hwnd,SB_VERT,-y0,TRUE);
         InvalidateRect(hwnd,NULL,TRUE);

	     return 0;
    case WM_HSCROLL:
	      
	     switch (LOWORD(wParam))
         {         case SB_TOP :x0=0;break;
	               case SB_BOTTOM :x0=HSmax;break;
                   case SB_LINEUP :x0++;break;
	               case SB_LINEDOWN :x0--;break;
	               case SB_PAGEUP :x0+=HSmax/10+1;break;
	               case SB_PAGEDOWN :x0+= -HSmax/10-1;break;
	               case SB_THUMBTRACK :x0= -HIWORD(wParam);break;
         }
         if (x0<-HSmax) x0=-HSmax;
         if (x0>0) x0=0;
	     SetScrollPos(hwnd,SB_HORZ,-x0,TRUE);
	     InvalidateRect(hwnd,NULL,TRUE);

	     return 0;
  }
  return DefWindowProc (hwnd,msg,wParam,lParam);
}



LRESULT CALLBACK ParamWndProc (HWND hwnd, UINT message, WPARAM wParam,
							  LPARAM lParam)

/* function for handling messages for the run nParameter Window */

{ param_win_data_type *wd; 
  param_setup_type *input;
  TEXTMETRIC tm;
  HDC         hdc ;
  PAINTSTRUCT ps ;
  RECT rect,rectw;
  static int wh,ww,user_sizing=0;
  int i,j,k;
  double y;
  static HINSTANCE hInstance;
  char text[50];
  if (message!=WM_CREATE) wd=(param_win_data_type *)GetWindowLong(hwnd,GWL_USERDATA);
  switch (message)
  { case WM_CREATE : // WM_CREATE is not the first message sent to a Window!!!
         wd=(param_win_data_type *)calloc(1,sizeof(param_win_data_type)); // window data
         input=(param_setup_type *) ((CREATESTRUCT *)lParam)->lpCreateParams;
         // now load wd from input data structure
         wd->nc=input->nc;
         wd->c=input->c;
         wd->editing=1; // allow editing of parameters at startup
         wd->cname=input->cname; // note no memory needs freeing now except input itself
         free(input);
         hInstance=(HINSTANCE) GetWindowLong(hwnd,GWL_HINSTANCE);
         hdc = GetDC(hwnd);
         wd->hFont=EzCreateFont(hdc,APPFONT,FONTSIZE,0,0,TRUE);
         SelectObject(hdc,wd->hFont);
     	 GetTextMetrics(hdc,&tm);
         wd->cxchar = (short) tm.tmAveCharWidth;
	     wd->cychar = (short)tm.tmHeight + (short)tm.tmExternalLeading;
         if (wd->nc)
	     { wd->hew=(HWND *)calloc((size_t)wd->nc,sizeof(HWND));
         }
	     wd->space=0;
         wd->x0=0;wd->y0=0;
 	     for (i=0;i<wd->nc;i++)
	     { GetTextExtentPoint32(hdc,wd->cname[i],strlen(wd->cname[i]),&(wd->wsize));
           if (wd->wsize.cx>wd->space) wd->space=(short)wd->wsize.cx;
         }
         GetTextExtentPoint32(hdc,"-0.0000e-00 ",strlen("-0.0000e-00 "),&(wd->wsize));
         wd->wsize.cx+=6;wd->wsize.cy+=4;
         wd->space+=wd->wsize.cx+10;
	     wd->height=9*wd->wsize.cy/8;

	     wd->cols=(short)ceil(sqrt(wd->height*wd->nc/((double) wd->space)));
         if (wd->cols) wd->rows=(short)ceil(wd->nc/((double)wd->cols));
         else wd->rows=0;

	     wd->xmax=GetDeviceCaps(hdc,HORZRES);
	     wd->ymax=GetDeviceCaps(hdc,VERTRES);
	     ww=wd->cols*wd->space+wd->cxchar*5; if (ww>wd->xmax) ww=wd->xmax;
         wh=wd->rows*wd->height+wd->cychar*6;if (wh>wd->ymax) wh=wd->ymax;
	     wd->ymax=wd->height*wd->rows+wd->cychar/2;  // maximum required height
         wd->xmax=wd->space*wd->cols;   // maximum required width

         k=0;
	     for (i=0;i<wd->rows;i++)
         for (j=0;j<wd->cols;j++)
	     if (k<wd->nc)
	     { sprintf(text,"%g",wd->c[k]);

	        wd->hew[k]=CreateWindow("edit",text,WS_CHILD|WS_VISIBLE|ES_LEFT|WS_BORDER,
	               wd->x0+2*wd->cxchar+wd->space*j,wd->y0+wd->height*i+wd->cychar/2,wd->wsize.cx,
                  wd->wsize.cy,hwnd,(HMENU)(300+k),hInstance,NULL);
            SendMessage(wd->hew[k],WM_SETFONT,(WPARAM) wd->hFont,(LPARAM)MAKELONG((WORD)TRUE,0));

	        k++;
	     }
         // now find the width of the window borders
         GetClientRect(hwnd,&rect);
         GetWindowRect(hwnd,&rectw);
         wd->ywedge=rectw.bottom-rectw.top-rect.bottom+rect.top;
         wd->xwedge=rectw.right-rectw.left-rect.right+rect.left; 
        
       
         
         SetWindowLong(hwnd,GWL_USERDATA,(LONG)wd); 
         SetWindowPos(hwnd,NULL,0,0,0,0,SWP_NOSIZE|SWP_NOMOVE); // purely to force above call to happen immediately
 
         ReleaseDC(hwnd,hdc);
       
         return 0;
     case WM_SETCURSOR :   // capturing cursor for editing
          if (wd->editing)
          for (i=0;i<wd->nc;i++)
          if (wd->hew[i]==(HWND)wParam)
          { SetFocus((HWND)wParam);return(0);}
          return DefWindowProc (hwnd, message, wParam, lParam) ;  
     case WM_MOVING:
          user_sizing=1;
          return(0);
     case WM_MOVE :
          if (user_sizing)
          { user_sizing=0;
            PostMessage(GetParent(hwnd),WM_COMMAND,(WPARAM)MAKELONG(10,0),(LPARAM)0);
          }    
          return(0);
     case WM_SIZING:
          user_sizing=1;
          return(0);
     case WM_SIZE :
            // cranky construction here is because Windows seems to assume scroll
            // bars are needed in order to work out client area, which forces them
            // to be needed!!        
            wd->y0=wd->x0=0;
            GetWindowRect(hwnd,&rectw);
            i=rectw.bottom-rectw.top-wd->ywedge;
            wd->VSmax=wd->ymax-i;
	        if (wd->VSmax<0) wd->VSmax=0;
	        SetScrollRange(hwnd,SB_VERT,0,wd->VSmax,FALSE);
	        SetScrollPos(hwnd,SB_VERT,0,TRUE);
 
            j=rectw.right-rectw.left-wd->xwedge; 
      	    wd->HSmax=wd->xmax-j;
	        if (wd->HSmax<0) wd->HSmax=0;
            SetScrollRange(hwnd,SB_HORZ,0,wd->HSmax,FALSE);
      	    SetScrollPos(hwnd,SB_HORZ,0,TRUE);  // follows on to paint
            if (user_sizing)
            { user_sizing=0;
              PostMessage(GetParent(hwnd),WM_COMMAND,(WPARAM)MAKELONG(10,0),(LPARAM)0);
            }                      
          return(0);
     case WM_PAINT :
          hdc = BeginPaint (hwnd, &ps) ;
          SelectObject(hdc,wd->hFont);
	      k=0;
	      for (i=0;i<wd->rows;i++) for (j=0;j<wd->cols;j++)
	      if (k<wd->nc)
	      { sprintf(text,"%7.3g",wd->c[k]);
            
	        MoveWindow(wd->hew[k],wd->x0+2*wd->cxchar+wd->space*j,wd->y0+wd->height*i+wd->cychar/2,
                       wd->wsize.cx,wd->wsize.cy,TRUE);
	        TextOut(hdc,wd->x0+2*wd->cxchar+wd->space*j+wd->wsize.cx+3,wd->y0+wd->height*i+wd->cychar/2,
                      wd->cname[k],strlen(wd->cname[k]));

            k++;
	      }
	      GetClientRect(hwnd,&rect);
          /* replace font with system font.....         */
          SelectObject(hdc,GetStockObject(SYSTEM_FONT));
          EndPaint (hwnd, &ps) ;
          return 0 ;

    case WM_DESTROY:
         if (wd->nc)
         { free(wd->c);
           free(wd->hew); 
         }
         DeleteObject(wd->hFont);
         free(wd);
	     return 0 ;

    case WM_COMMAND:
         switch (LOWORD(wParam))
         { case 1: // new values for parameters, put in wd by parent
	            { for (k=0;k<wd->nc;k++)
	              { sprintf(text,"%g",wd->c[k]);
                    if (strlen(text)>8)
	                sprintf(text,"%7.3g",wd->c[k]);
                    SetWindowText(wd->hew[k],text);
                  }
                  break;
	            }


           case 3: // parent would like current edit window values put into wd->c
                   { for (i=0;i<wd->nc;i++)
	                 { j=GetWindowTextLength(wd->hew[i]);
                       if (j)
	                   { GetWindowText(wd->hew[i],text,j+1);  // UDF: its i+1 in order to read '\0'
                         sscanf(text,"%lf",&y);
	                     wd->c[i]=y;
                       }
                     }
                     break;
                   }
           case 4: // parent wishes to disable editing
                   { wd->editing=0;break;}
           case 5: // parent wishes to enbable editing
                   { wd->editing=1;break;}  
	     
	     
       }
       return(0);

    case WM_VSCROLL:
	switch (LOWORD(wParam))
	{ case SB_TOP :wd->y0=0;break;
	  case SB_BOTTOM :wd->y0=wd->VSmax;break;
	  case SB_LINEUP :wd->y0++;break;
	  case SB_LINEDOWN :wd->y0--;break;
	  case SB_PAGEUP :wd->y0+=wd->VSmax/10+1;break;
	  case SB_PAGEDOWN :wd->y0+= -wd->VSmax/10-1;break;
      case SB_THUMBTRACK :wd->y0= -HIWORD(wParam);break;
 	}
	if (wd->y0<-wd->VSmax) wd->y0= -wd->VSmax;
    if (wd->y0>0) wd->y0=0;
	SetScrollPos(hwnd,SB_VERT,-wd->y0,TRUE);
	InvalidateRect(hwnd,NULL,TRUE);
    return 0;
    
    case WM_HSCROLL:
	switch (LOWORD(wParam))
	{ case SB_TOP :wd->x0=0;break;
	  case SB_BOTTOM :wd->x0=wd->HSmax;break;
	  case SB_LINEUP :wd->x0++;break;
	  case SB_LINEDOWN :wd->x0--;break;
	  case SB_PAGEUP :wd->x0+=wd->HSmax/10+1;break;
	  case SB_PAGEDOWN :wd->x0+= -wd->HSmax/10-1;break;
	  case SB_THUMBTRACK :wd->x0= -HIWORD(wParam);break;
	}
	if (wd->x0<-wd->HSmax) wd->x0=-wd->HSmax;
    if (wd->x0>0) wd->x0=0;
	SetScrollPos(hwnd,SB_HORZ,-wd->x0,TRUE);
	InvalidateRect(hwnd,NULL,TRUE);
	return 0;
   }
   return DefWindowProc (hwnd, message, wParam, lParam) ;
}



LRESULT CALLBACK  ClientWndProc (HWND hwnd, UINT msg, WPARAM mp1, LPARAM mp2)

/* The function that handles messages for the output graphics windows */

{ plot_setup_type *set;
  winplotype *w;
  HDC hdc;
  RECT rect;
  PAINTSTRUCT ps;
  double *x;
  int i,n;
  static FARPROC lpfnRescaleBox;
  static HANDLE hInstance;
  static int started=0,user_sizing=0; //offsets at which to start painting
  static SIZE bsize;
  if (msg!=WM_CREATE) w=(winplotype *)GetWindowLong(hwnd,GWL_USERDATA);
  switch (msg)
  { case WM_CREATE :
    set=(plot_setup_type *) ((CREATESTRUCT *)mp2)->lpCreateParams;
    w=(winplotype *)calloc(1,sizeof(winplotype)); // storage for window data
    hdc=GetDC(hwnd);
    w->hFont=EzCreateFont(hdc,APPFONT,FONTSIZE,0,0,TRUE);
    SelectObject(hdc,w->hFont);
	w->newaxes=1;
    if (!started)
	{ hInstance=(HINSTANCE) GetWindowLong(hwnd,GWL_HINSTANCE);
	  lpfnRescaleBox=MakeProcInstance ((FARPROC)RescaleProc, hInstance);
      GetTextExtentPoint32(hdc,"Rescale",strlen("Rescale"),&bsize);
      bsize.cy+=2;bsize.cx+=6;
    }
    w->hwndb=CreateWindow("button","Rescale",WS_CHILD|WS_VISIBLE|
	                       BS_PUSHBUTTON,0,0,bsize.cx,bsize.cx,hwnd,(HMENU)45,
				           ((LPCREATESTRUCT) mp2)->hInstance,NULL);
    SendMessage(w->hwndb,WM_SETFONT,(WPARAM) w->hFont,(LPARAM)MAKELONG((WORD)TRUE,0));

    SelectObject(hdc,GetStockObject(SYSTEM_FONT));
    ReleaseDC(hwnd,hdc);
	started++;
	InvalidateRect(hwnd,NULL,TRUE);
    // load some window data
    w->label=(char **)calloc((size_t)set->ndisv,sizeof(char *));
    for (i=0;i<set->ndisv;i++) w->label[i]=set->label[i];
    w->nvar=set->ndisv; 
    w->x0=set->x0;
    w->x1=set->x1;
    w->y0=set->y0;
    w->y1=set->y1;
    // start windows empty.....
    w->plot_raw=0;
    w->n = 0;
    w->data=(xytype **)calloc((size_t)w->nvar,sizeof(xytype*)); 
    w->raw=(xytype **)calloc((size_t)w->nvar,sizeof(xytype*)); 
    w->no_raw_points=(int *)calloc((size_t)w->nvar,sizeof(int));
    w->raw_alloc=0;
    // now store window data
    SetWindowLong(hwnd,GWL_USERDATA,(LONG)w); 
    SetWindowPos(hwnd,NULL,0,0,0,0,SWP_NOSIZE|SWP_NOMOVE); 
    return(0);
    
    case WM_SIZING:
    user_sizing=1;
    return(0);
    case WM_SIZE :
   	if (user_sizing)
    { user_sizing=0;
      PostMessage(GetParent(hwnd),WM_COMMAND,(WPARAM)MAKELONG(10,0),(LPARAM)0);
    }
    w->resize=1;
	w->llx=0;w->lly=0;
	w->urx=LOWORD( mp2 );
	w->ury=HIWORD( mp2 );
 
	return 0;
    case WM_MOVING:
    user_sizing=1;
    return(0);
    case WM_MOVE:
    if (user_sizing)
    { user_sizing=0;
      PostMessage(GetParent(hwnd),WM_COMMAND,(WPARAM)MAKELONG(10,0),(LPARAM)0);
    }
    return 0;
    case WM_PAINT:
	w->paintcount++;
    GetClientRect (hwnd, &rect) ;
	InvalidateRect(hwnd,&rect,TRUE);
    hdc=BeginPaint(hwnd,&ps);
    SelectObject(hdc,w->hFont);

    GetClientRect (hwnd, &rect) ;
	FillRect(hdc,(RECT*)&rect,(HBRUSH)GetStockObject(WHITE_BRUSH));
	tplot(hdc,hwnd,w,1);
    MoveWindow(w->hwndb,2,rect.bottom-bsize.cy-2,bsize.cx,bsize.cy,TRUE);
    SelectObject(hdc,GetStockObject(SYSTEM_FONT));   
    EndPaint(hwnd,&ps);
    if (w->paintcount>10)
    w->paintcount=0;
	return 0;


    case WM_COMMAND :
	switch(LOWORD(mp1))
    { case 1: // parent wants to rescale the x-axis
              { x=(double *)mp2;
                w->x0=x[0];w->x1=x[1];w->newaxes=1;
                return(0);
              } 
      case 2: //rescale the window as parent has resized 
              { GetClientRect(GetParent(hwnd),&rect);
                SetWindowPos(hwnd,HWND_TOP,(long)round(rect.right*w->left),
                (long)round(rect.bottom*w->top),(long)round(rect.right*(w->right-w->left)),
                (long)round(rect.bottom*(w->bottom-w->top)),SWP_SHOWWINDOW );
                return(0);
              }

      case 3: // its the update window message
	         { hdc=GetDC(hwnd);
               SelectObject(hdc,w->hFont);
	   
               tplot(hdc,hwnd,w,1);
               
               SelectObject(hdc,GetStockObject(SYSTEM_FONT));
               ReleaseDC(hwnd,hdc);
	           return 0 ;
 	         }
       case 4: // parent wishes to place mp2 points of model data in w->data 
             { w->n=(int)mp2; // amount of data to be deposited
               if ((w->n > w->datasize)||(w->n<w->datasize-200)) // expand/contract storage in w->data
               { n=((w->n/200)+1)*200; // new buffer size
                 for (i=0;i<w->nvar;i++) 
                 w->data[i]=(xytype *)realloc(w->data[i],(size_t)n*sizeof(xytype));
               }
               return(0);
             } 
       case 5: // parent wishes to place at most mp2 points of raw data in the raw data buffer
              { n=(int)mp2;
                if ((n>w->raw_alloc)||(n<w->raw_alloc/2)) // then modify raw buffer
                { w->raw_alloc=n;
                  for (i=0;i<w->nvar;i++) 
                  w->raw[i]=(xytype *)realloc(w->raw[i],(size_t)n*sizeof(xytype));
                } 
                for (i=0;i<w->nvar;i++) 
                w->no_raw_points[i]=0; // resetting counter to zero
                return(0); 
              }
       case 6: // turn on raw data display
               { w->plot_raw=1;return(0);
               } 
       case 7: // turn off raw data display
               { w->plot_raw=0;return(0);
               }
	   case 45: // rescale button pressed 
	           {  DialogBoxParam(hInstance,(LPCTSTR)"Rescale",hwnd,(DLGPROC)lpfnRescaleBox,(LPARAM)hwnd); 
  	              ShowWindow(w->hwndb,TRUE);
	              return 0;
               } 
	}

    case WM_DESTROY:
	// window data memory should be freed here
    started--;
	return 0;

  }
  return DefWindowProc (hwnd,msg,mp1,mp2);

}


void jointhedots(double *xk,double *yk,double *x,double *y, int df,int points,int setup)

/* Interpolates the uf knots in xk, yk to obtain `points' evenly spaced points
   in x, y. Cubic spline interpolation is used. */

{ int i,j;
  double dt,tt,xx;
  static matrix t,a,b,c,d;
  t.V=xk;t.r=(long) df;t.c=1L;a.V=yk;a.r=(long) df;a.c=1L;
  if (setup)
  { b.V=(double *)calloc((size_t)df,sizeof(double));b.r=(long)df;
    c.V=(double *)calloc((size_t)df,sizeof(double));c.r=(long)df;
    d.V=(double *)calloc((size_t)df,sizeof(double));d.r=(long)df;
    return;
  }
  b.r=c.r=d.r=(long)df;
  splcoeffs(t,a,b,c,d);
  dt=(t.V[t.r-1]-t.V[0])/(points-1);
  j=0;tt=t.V[0];
  for (i=0;i<points;i++)
  { while ((j<t.r-2)&&(xk[j+1]<tt)) j++;
    xx=tt-xk[j];
    x[i]=tt;
    y[i]=a.V[j]+(b.V[j]+(c.V[j]+d.V[j]*xx)*xx)*xx;
    tt+=dt;
  }
}

void WriteUF(parent_win_data_type *pwd,fit_control_type *fit,char *name)

/* Routine to write ufs and their standard error bands to a file 
   Note that this routine assumes that jointhedots has been called with setup==1
   and df large enough to accomodate any of the uf's.
*/

{ FILE *fi;
  int i,j,k,n=100;
  double **x,**y,**xsd,**ysd,**sd;
  x=(double **)calloc((size_t)fit->n_uf,sizeof(double *));
  y=(double **)calloc((size_t)fit->n_uf,sizeof(double *));
  xsd=(double **)calloc((size_t)fit->n_uf,sizeof(double *));
  ysd=(double **)calloc((size_t)fit->n_uf,sizeof(double *));
  sd=(double **)calloc((size_t)fit->n_uf,sizeof(double *));
  k=fit->n_uc;
  for (i=0;i<fit->n_uf;i++)
  { sd[i]=(double *)calloc((size_t)pwd->ufdf[i],sizeof(double));
    for (j=0;j<pwd->ufdf[i];j++) { sd[i][j]=sqrt(fit->Vp[k][k]);k++;} 
    x[i]=(double *)calloc((size_t)n,sizeof(double));
    y[i]=(double *)calloc((size_t)n,sizeof(double));
    xsd[i]=(double *)calloc((size_t)n,sizeof(double));
    ysd[i]=(double *)calloc((size_t)n,sizeof(double));
    jointhedots(pwd->ufx[i],pwd->ufy[i],x[i],y[i],pwd->ufdf[i],n,0);
    jointhedots(pwd->ufx[i],sd[i],xsd[i],ysd[i],pwd->ufdf[i],n,0);
  }
  fi=fopen(name,"wt");
  for (i=0;i<n;i++)
  { if (i) fprintf(fi,"\n"); 
    for (j=0;j<pwd->n_uf;j++) 
    fprintf(fi,"%11.4g  %11.4g  %11.4g    ",x[j][i],y[j][i],ysd[j][i]<0.0?0.0:ysd[j][i]);
  }
  fclose(fi);
  for (i=0;i<fit->n_uf;i++)
  { free(sd[i]);
    free(x[i]);
    free(y[i]);
    free(xsd[i]);
    free(ysd[i]);
  }
  free(sd);free(x);free(y);free(xsd);free(ysd);
} 


void ufknotupdate(int moving,double ynew,double *x,double *y, int df,
                  int nak,int  mesh,int setup)

/* Takes information about user modification of a knot and updates other knots
   accordingly This is done by spline interpolation between `active knots'
   (which the user can move) */

{ static matrix xk,yk,b,c,d;
  int i,j;
  double xx;
  /* setup storage for active knots only */
  if (setup)
  { xk.V=(double *)calloc((size_t)nak,sizeof(double));xk.r=(long)nak;
    yk.V=(double *)calloc((size_t)nak,sizeof(double));yk.r=(long)nak;
    d.V=(double *)calloc((size_t)nak,sizeof(double));d.r=(long)nak;
    b.V=(double *)calloc((size_t)nak,sizeof(double));b.r=(long)nak;
    c.V=(double *)calloc((size_t)nak,sizeof(double));c.r=(long)nak;   
    return;
  }
  xk.r=yk.r=d.r=b.r=c.r=(long)nak;

  /* read active knots into xk, yk */
  i=0;
  while (i*mesh<df){ xk.V[i]=x[i*mesh];yk.V[i]=y[i*mesh];i++;}
  if ((i>nak)||((i-1)*mesh>=df)) ErrorMessage("Error in ufupdateknot",0);
  if ((i-1)*mesh-1!=df-1) { xk.V[i]=x[df-1];yk.V[i]=y[df-1];}
  yk.V[moving]=ynew;
  /* get coeffs */
  splcoeffs(xk,yk,b,c,d);
  /* output results to y */
  j=0;
  for (i=0;i<df;i++)
  { while ((j<nak-2)&&(xk.V[j+1]<x[i])) j++;
    xx=x[i]-xk.V[j];
    y[i]=yk.V[j]+(b.V[j]+(c.V[j]+d.V[j]*xx)*xx)*xx;
  }

}


LRESULT CALLBACK  FunctionWndProc (HWND hwnd, UINT msg, WPARAM mp1, LPARAM mp2)

/* The function that handles messages for the function windows
   These windows have a dual function:
   a: to allow adjustment of the UFs prior to fitting
   b: to display the UFs as they are fitted.
   
   Data i/o is as follows: 

   1. On WM_CREATE the parent window data is interrogated to get ufdf[i]
      ufx[i][] and ufy[i][], (int) mp2 is assumed to contain i.
   2. On WM_COMMAND 3 the parent window data is interrogated as in 1. and 
      the window re-drawn.
   3. On WM_COMMAND 1 new ufy[i] values are copied into the Parent data structure
   
   The data for a function window is stored in a data structiure
   of type ufwindatatype.

*/

{ parent_win_data_type *pwd;
  HWND parent;
  static ufwindatatype *wd; // static for debug only
  static int i,base,j;
  static double xmult,ymult,ynew,x0,y0;
  char sx0[20],sx1[20],sy0[20],sy1[20],sexx[20],sexy[20];
  HDC hdc;
  RECT rect;
  static int user_sizing=0;
  static HPEN pen[2];
  static int first=1,wincount=0, outp=100; // is user input allowed?
  static HINSTANCE hInstance;
  static HFONT hFont;
  static SIZE bsize,exxsize,exysize,x0size,x1size,y0size,y1size;
  POINT q,p;
  POINTS mp; /* mouse co-ordinates */
  PAINTSTRUCT ps;
  HFONT hFont1;
  static int border=10,xborder=10,yborder=10;
  static FARPROC lpfnRescaleBox;
  switch (msg)
  { case WM_CREATE :
    parent=(HWND)GetWindowLong(hwnd,GWL_HWNDPARENT);
    pwd=(parent_win_data_type *)GetWindowLong(parent,GWL_USERDATA);
    
    hdc=BeginPaint(hwnd,&ps);
    if (first)
    { first=0;
      pen[0]=CreatePen(PS_SOLID,1,RGB(0,0,0));
      pen[1]=CreatePen(PS_SOLID,1,RGB(255,0,0));
      hInstance=(HINSTANCE) GetWindowLong(hwnd,GWL_HINSTANCE);
      lpfnRescaleBox=MakeProcInstance((FARPROC)ufRescaleProc, hInstance);
      hFont=EzCreateFont(hdc,"Arial",FONTSIZE,0,0,TRUE);
    }
    SelectObject(hdc,hFont);
    GetTextExtentPoint32(hdc,"R", strlen("R"), &bsize);
    bsize.cy+=4;bsize.cx+=4;
    SelectObject(hdc,GetStockObject(SYSTEM_FONT));
    EndPaint(hwnd,&ps);
    wd=(ufwindatatype *)calloc(1,sizeof(ufwindatatype));
    wd->id=(int) ((CREATESTRUCT *)mp2)->lpCreateParams; // reading ufwindow id from startup param
	wd->df=pwd->ufdf[wd->id];  
	wd->x0=pwd->ufx[wd->id][0];wd->x1=pwd->ufx[wd->id][pwd->ufdf[wd->id]-1]; 
	wd->y0=wd->y1=0.0;

    for (i=0;i<wd->df;i++)
    { if (wd->y1<pwd->ufy[wd->id][i]) wd->y1=pwd->ufy[wd->id][i]; 
      if (wd->y0>pwd->ufy[wd->id][i]) wd->y0=pwd->ufy[wd->id][i]; 
    }
    if (wd->y1!=wd->y0)
    { if (wd->y1!=0.0)wd->y1+=(wd->y1-wd->y0)*0.5;
      if (wd->y0!=0.0)wd->y0-=(wd->y1-wd->y0)*0.5;
    } else if (wd->y0!=0.0)
    { wd->y1+=fabs(wd->y0);
      wd->y0-=fabs(wd->y0);
    } else
    { wd->y1+=1.0;wd->y0 -= 1.0;}

    /* obtain axes scales */
    scale(wd->x0,wd->x1,&x0,&(wd->dx),&(wd->nx),&(wd->exx));
    wd->xm=pow(10.0,wd->exx);
    scale(wd->y0,wd->y1,&y0,&(wd->dy),&(wd->ny),&(wd->exy));
    wd->ym=pow(10.0,wd->exy);
    wd->x0=x0;wd->y0=y0;wd->x1=x0+wd->dx*wd->nx;wd->y1=y0+wd->ny*wd->dy;
	 wd->mesh=1;
	 while (wd->df/wd->mesh>10) wd->mesh++; /* user can move every mesh knot */
	 wd->nak=wd->df/wd->mesh;
	 while (wd->mesh*(wd->nak-1)<wd->df-1) wd->nak++;
	 wd->xk=(double *)calloc((size_t)wd->df,sizeof(double));  /* xpos, all knots */
	 wd->yk=(double *)calloc((size_t)wd->df,sizeof(double)); /* ypos, all knots */
	 for (i=0;i<wd->df;i++)
	 { wd->xk[i]=pwd->ufx[wd->id][i];         
	   wd->yk[i]=pwd->ufy[wd->id][i];         
     }
 	 wd->ix0=(int *)calloc((size_t)wd->nak,sizeof(int));  /* left edge of ith point */
	 wd->ix1=(int *)calloc((size_t)wd->nak,sizeof(int));  /* right edge of ith point */
	 wd->iy0=(int *)calloc((size_t)wd->nak,sizeof(int));  /* lower edge of ith point */
	 wd->iy1=(int *)calloc((size_t)wd->nak,sizeof(int));  /* upper edge of ith point */
	 wd->x=(double *)calloc((size_t)outp,sizeof(double));  /* x values for function o/p */
	 wd->y=(double *)calloc((size_t)outp,sizeof(double)); /* y values for function o/p */	 wd->moving=-1;  /* none of the points are moving yet */
	 jointhedots(wd->xk,wd->yk,wd->x,wd->y,wd->df,outp,0);

    wd->rsbhwnd=CreateWindow("button","R",WS_CHILD|WS_VISIBLE|
	                         BS_PUSHBUTTON,100,0,bsize.cx,bsize.cy,hwnd,(HMENU)30,
				                ((LPCREATESTRUCT) mp2)->hInstance,NULL);
    SendMessage(wd->rsbhwnd,WM_SETFONT,(WPARAM) hFont,(LPARAM)MAKELONG((WORD)TRUE,0));

	SetWindowLong(hwnd,GWL_USERDATA,(LONG)wd);  /* initialise data for this window */
    SetWindowPos(hwnd,NULL,0,0,0,0,SWP_NOSIZE|SWP_NOMOVE); // purely to force above call to happen immediately
 
    
	wincount++;
    return(0);
    case WM_MOVING:
    user_sizing=1;
    return(0);
    case WM_MOVE :
    if (user_sizing) // send message to parent that user has resized window
    { PostMessage(GetParent(hwnd),WM_COMMAND,(WPARAM)MAKELONG(10,0),(LPARAM)0);
      user_sizing=0;
    }
   
    return(0);
    case WM_SIZING :
    user_sizing=1; // indicate that the user is resizing the window
    return(0);
    case WM_SIZE :
   
    if (user_sizing) // send message to parent that user has resized window
    { PostMessage(GetParent(hwnd),WM_COMMAND,(WPARAM)MAKELONG(10,0),(LPARAM)0);
      user_sizing=0;
    }
	InvalidateRect(hwnd,NULL,TRUE);
	return(0);

    case WM_PAINT :
  	wd=(ufwindatatype *)GetWindowLong(hwnd,GWL_USERDATA);
	hdc=BeginPaint(hwnd,&ps);
    /* Load an appropriate font for the current window size */
    GetClientRect(hwnd,&rect);
    i=(rect.bottom+rect.right)/6;if (i<50) i=50;if (i>120) i=120;
    hFont1=EzCreateFont(hdc,"Arial",i,0,0,TRUE);
    SelectObject(hdc,hFont1);

    /* Produce output labels and get their dimensions */
    if (wd->exx!=0.0)
    { sprintf(sexx,"e%g",wd->exx);
      GetTextExtentPoint32(hdc,sexx, strlen(sexx), &exxsize);
    } else {exxsize.cy=exxsize.cx=0;}
    sprintf(sx0,"%g",wd->x0);
    GetTextExtentPoint32(hdc,sx0, strlen(sx0), &x0size);
    sprintf(sx1,"%g",wd->x1);
    GetTextExtentPoint32(hdc,sx1, strlen(sx1), &x1size);
    if (x0size.cy>x1size.cy) yborder=4+x0size.cy+exxsize.cy;else
                             yborder=4+x1size.cy+exxsize.cy;
    if (wd->exy!=0.0)
    { sprintf(sexy,"e%g",wd->exy);
      GetTextExtentPoint32(hdc,sexy, strlen(sexy), &exysize);
    } else {exysize.cy=exysize.cx=0;}

    sprintf(sy0,"%g",wd->y0);
    GetTextExtentPoint32(hdc,sy0, strlen(sy0), &y0size);
    xborder=y0size.cx;
    sprintf(sy1,"%g",wd->y1);

    GetTextExtentPoint32(hdc,sy1, strlen(sy1), &y1size);
    if (y1size.cx>xborder) xborder=y1size.cx;
    xborder+=exysize.cx;

    /* decide whether plot will be labelled, and set xborder and yborder */
    if (yborder>(rect.bottom-2*border)/3) yborder=0;
    if (xborder>(rect.right-2*border)/4) xborder=0;

    GetClientRect(hwnd,&rect);
	 /* get scale factors */
    base=rect.bottom-rect.top;
	 xmult=(rect.right-rect.left-2*border-xborder)/((wd->x1-wd->x0)*wd->xm);
	 ymult= -(base-2*border-yborder)/((wd->y1-wd->y0)*wd->ym);

	 /* get knot positions in window */
  	 i=0;
  	 while (i*wd->mesh<wd->df)
	 { if (i>=wd->nak)
      ErrorMessage("Fuck up in UF window",0);
      wd->ix0[i]=border+xborder-2+(int)round(xmult*(wd->xk[i*wd->mesh]-wd->x0*wd->xm));
	   wd->ix1[i]=wd->ix0[i]+4;
	   wd->iy0[i]=base-border-yborder-2+(int)round(ymult*(wd->yk[i*wd->mesh]-wd->y0*wd->ym));
	   wd->iy1[i]=wd->iy0[i]+4;
	   i++;
	 }
	 if ((i-1)*wd->mesh!=wd->df-1)
	 { if (i>=wd->nak)
      ErrorMessage("Error in UF window",0);
      wd->ix0[i]=border+xborder-2+(int)round(xmult*(wd->xk[wd->df-1]-wd->x0*wd->xm));
	   wd->ix1[i]=wd->ix0[i]+4;
	   wd->iy0[i]=base -border-yborder-2 +
                (int)round(ymult*(wd->yk[wd->df-1]-wd->y0*wd->ym));
	   wd->iy1[i]=wd->iy0[i]+4;
	 }
	 FillRect(hdc,/*(PRECT)*/&rect,(HBRUSH)GetStockObject(WHITE_BRUSH));

    /* draw axes */
    SelectObject(hdc,pen[1]);
    q.x=(INT)(border+xborder);q.y=(INT)(base-border-yborder+5);
	MoveTo(hdc,q.x,q.y);
    q.x=(INT)((wd->x1-wd->x0)*wd->xm*xmult+border+xborder);
    q.y=(INT)(base-border-yborder+5);
    LineTo(hdc,q.x,q.y);
    q.x=(INT)(border+xborder-5);q.y=(INT)(base-border-yborder);
	 MoveTo(hdc,q.x,q.y);
    q.x=(INT)(border+xborder-5);
    q.y=(INT)(base+(wd->y1-wd->y0)*wd->ym*ymult-border-yborder);
    LineTo(hdc,q.x,q.y);
    /* draw ticks on axes */
    for (i=0;i<=wd->ny;i++)   // y axis
    { q.x=(INT)(border+xborder-5);q.y=(INT)(wd->dy*wd->ym*i*ymult+base-border-yborder);
	   MoveTo(hdc,q.x,q.y);q.x -= 4;
      LineTo(hdc,q.x,q.y);
    }
    for (i=0;i<=wd->nx;i++)  // x axis
    { q.x=(INT)(wd->dx*wd->xm*i*xmult+border+xborder);q.y=(INT)(base-border-yborder+5);
	   MoveTo(hdc,q.x,q.y);q.y += 4;
      LineTo(hdc,q.x,q.y);
    }


    if (xborder) /* label y axis */
    { TextOut(hdc,xborder-y1size.cx,(int)((wd->y1-wd->y0)*wd->ym*ymult)+base-border-yborder-y1size.cy/2
              ,sy1,strlen(sy1));
      if (exysize.cx)
      TextOut(hdc,xborder-exysize.cx,(int)((wd->y1-wd->y0)*wd->ym*ymult)+base-border-yborder+5*y1size.cy/8
              ,sexy,strlen(sexy));
      TextOut(hdc,xborder-y0size.cx,(int)base-border-yborder-y0size.cy/2
              ,sy0,strlen(sy0));
    }
    if (yborder) /* label x axis */
    { TextOut(hdc,border+xborder-x0size.cx/2,base-5-x0size.cy-exxsize.cy,sx0,strlen(sx0));
      if (x1size.cx>exxsize.cx) j=x1size.cx; else j=exxsize.cx;
      if (j/2<border)
      i=(int)((wd->x1-wd->x0)*wd->xm*xmult)+border+xborder-j/2;else
      i=(int)((wd->x1-wd->x0)*wd->xm*xmult)+2*border+xborder-j;
      if (exxsize.cx)
      TextOut(hdc,i,base-5-x0size.cy,sexx,strlen(sexx));
      TextOut(hdc,i,base-5-x0size.cy-exxsize.cy,sx1,strlen(sx1));
    }
	 /* plot the interpolated function */

  	 q.x=(INT)((wd->x[0]-wd->x0*wd->xm)*xmult+border+xborder);
	 q.y=(INT)(base+(wd->y[0]-wd->y0*wd->ym)*ymult-border-yborder);
	 MoveTo(hdc,q.x,q.y);
	 for (i=1;i<outp;i++)
	 { q.x=(INT)((wd->x[i]-wd->x0*wd->xm)*xmult+border+xborder);
	   q.y=(INT)(base+(wd->y[i]-wd->y0*wd->ym)*ymult-border-yborder);
      LineTo(hdc,q.x,q.y);
	 }
	 /* plot moveable knots */

    for (i=0;i<wd->nak;i++)
	{ p.y=(INT)wd->iy0[i];p.x=(INT)wd->ix0[i];
	  q.y=(INT)wd->iy1[i];q.x=(INT)wd->ix1[i];
      Rectangle(hdc,p.x,p.y,q.x,q.y);
  	 }
    MoveWindow(wd->rsbhwnd,rect.right-bsize.cx,0,bsize.cx,bsize.cy,TRUE);
	InvalidateRect(wd->rsbhwnd,NULL,TRUE);
    SelectObject(hdc,pen[0]);
     /* draw x input range on x axis */
    if (wd->xmax>wd->x1*wd->xm) wd->xmax=wd->x1*wd->xm;
    if (wd->xmin<wd->x0*wd->xm) wd->xmin=wd->x0*wd->xm;
    if (wd->xmin<=wd->xmax)
    { q.x=(INT)((wd->xmin-wd->x0*wd->xm)*xmult+border+xborder);
      q.y=(INT)(base-border-yborder+5);
      MoveTo(hdc,q.x,q.y);
      q.x=(INT)((wd->xmax-wd->x0*wd->xm)*xmult+border+xborder);
      q.y=(INT)(base-border-yborder+5);
      LineTo(hdc,q.x,q.y);
    }
    SelectObject(hdc,GetStockObject(SYSTEM_FONT));
	EndPaint(hwnd,&ps);
    DeleteObject(hFont1);
	return(0);

    case WM_LBUTTONDOWN:
    wd=(ufwindatatype *)GetWindowLong(hwnd,GWL_USERDATA);
 	 /* check if position is in an active knot */
	 mp.x=LOWORD(mp2);mp.y=HIWORD(mp2);
	 wd->moving=-1;
	 for (i=0;i<wd->nak;i++)
	 { if ((mp.x>=wd->ix0[i])&&(mp.x<=wd->ix1[i])&&
	       (mp.y>=wd->iy0[i])&&(mp.y<=wd->iy1[i]))
	   { wd->moving=i;i=wd->nak;}
	 }
	 if (wd->moving>=0) /* user has clicked on a knot */
	 { SetCapture(hwnd);	   /* capture the mouse (don't allow message boxes while captured) */
	 }
	 return(0);

    case WM_LBUTTONUP: /* user has released mouse button */
    wd=(ufwindatatype *)GetWindowLong(hwnd,GWL_USERDATA);
	 if (wd->moving>=0)
	 { mp.y=HIWORD(mp2);
      ReleaseCapture();
      /* get the y range of the window, figure out new value for the knot */
	   GetClientRect(hwnd,&rect);
      base=rect.bottom-rect.top;
	   ymult= -(base-2*border-yborder)/((wd->y1-wd->y0)*wd->ym);
	   ynew=(mp.y-base+border+yborder)/ymult+wd->y0*wd->ym;
      if (ynew<wd->y0*wd->ym) ynew=wd->y0*wd->ym;
      if (ynew>wd->y1*wd->ym) ynew=wd->y1*wd->ym;
	   /* call routine that updates all knots in light of move (not just active) */
	   ufknotupdate(wd->moving,ynew,wd->xk,wd->yk,wd->df,wd->nak,wd->mesh,0);
	   InvalidateRect(hwnd,NULL,TRUE);
	   /* copy new knot values to global data structure */
  
	   jointhedots(wd->xk,wd->yk,wd->x,wd->y,wd->df,outp,0);
	   wd->moving=-1;
	 }
	 return(0);

    case WM_COMMAND :
	switch (LOWORD(mp1)) 
    { case 1: // read knot values into parent data structure
      { wd=(ufwindatatype *)GetWindowLong(hwnd,GWL_USERDATA);
	    pwd=(parent_win_data_type *)GetWindowLong((HWND)GetWindowLong(hwnd,GWL_HWNDPARENT),GWL_USERDATA);
        for (i=0;i<wd->df;i++)  /* update the knot information */
	    { pwd->ufy[wd->id][i]=wd->yk[i];     
	    }
        break;
      } 
      case 2: /* rescale the window as parent has resized */
      { GetClientRect(GetParent(hwnd),&rect);
        wd=(ufwindatatype *)GetWindowLong(hwnd,GWL_USERDATA);
        SetWindowPos(hwnd,HWND_TOP,(long)round(rect.right*wd->left),
           (long)round(rect.bottom*wd->top),(long)round(rect.right*(wd->right-wd->left)),
           (long)round(rect.bottom*(wd->bottom-wd->top)),SWP_SHOWWINDOW );
        break;
      }
      case 3: // its the update window message
	  { wd=(ufwindatatype *)GetWindowLong(hwnd,GWL_USERDATA);
	    pwd=(parent_win_data_type *)GetWindowLong((HWND)GetWindowLong(hwnd,GWL_HWNDPARENT),GWL_USERDATA);
        for (i=0;i<wd->df;i++)  /* update the knot information */
	    { wd->xk[i]=pwd->ufx[wd->id][i];     
	      wd->yk[i]=pwd->ufy[wd->id][i];     
	    }
        wd->xmin=pwd->ufxmin[wd->id];        
        wd->xmax=pwd->ufxmax[wd->id];        
	    jointhedots(wd->xk,wd->yk,wd->x,wd->y,wd->df,outp,0);
	    InvalidateRect(hwnd,NULL,TRUE);
        break;
	  } 
	  case 30: /* Message from "R" button */
	  { wd=(ufwindatatype *)GetWindowLong(hwnd,GWL_USERDATA);
        DialogBoxParam(hInstance,(LPCTSTR)"Rescale",GetParent(hwnd),(DLGPROC)lpfnRescaleBox,(LPARAM)hwnd);
        scale(wd->y0,wd->y1,&y0,&(wd->dy),&(wd->ny),&(wd->exy));
        wd->y0=y0;wd->y1=y0+wd->ny*wd->dy;
        wd->ym=pow(10.0,wd->exy);
        break;
  	  } 
      
    }
    return(0);
    case WM_DESTROY:
    return(0);
  }
  return DefWindowProc (hwnd,msg,mp1,mp2);

}


WNDCLASSEX define_graphics_window_class(HINSTANCE hInstance)

{ WNDCLASSEX gwclass;
  char *ClassName;
  ClassName="CLIENT";
  gwclass.cbSize=sizeof(gwclass);
  gwclass.style=CS_HREDRAW|CS_VREDRAW|CS_OWNDC;
  gwclass.lpszClassName=ClassName;
  gwclass.hInstance=hInstance;
  gwclass.lpfnWndProc=ClientWndProc;
  gwclass.hCursor=LoadCursor(NULL,IDC_ARROW);
  gwclass.hIcon=LoadIcon(NULL,IDI_APPLICATION);
  gwclass.hIconSm=LoadIcon(NULL,IDI_APPLICATION);
  gwclass.lpszMenuName=NULL;
  gwclass.hbrBackground=(HBRUSH) GetStockObject(WHITE_BRUSH);
  gwclass.cbWndExtra=sizeof(winplotype*);  
  gwclass.cbClsExtra=0;
  return(gwclass);
}

WNDCLASSEX define_parameter_window_class(HINSTANCE hInstance)

{ WNDCLASSEX paramclass;
  char *ClassName;
  ClassName="PARAM";
  paramclass.cbSize=sizeof(paramclass);
  paramclass.style         = CS_HREDRAW | CS_VREDRAW |CS_OWNDC;
  paramclass.lpfnWndProc   = ParamWndProc ;
  paramclass.cbClsExtra    = 0 ;
  paramclass.cbWndExtra    = sizeof(param_win_data_type*) ;
  paramclass.hInstance     = hInstance ;
  paramclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
  paramclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
  paramclass.hIconSm       = LoadIcon(NULL,IDI_APPLICATION);
  paramclass.hbrBackground = (HBRUSH)GetStockObject (WHITE_BRUSH) ;
  paramclass.lpszMenuName  = NULL ;
  paramclass.lpszClassName = ClassName;
  return(paramclass);
}

void tiler(RECT area, RECT *pos, RECT *spare, int n)

/* Arranges n identical windows within area, returning postions in pos[]. All co-ords
   relative to client, not top left of area. Tries to keep them wider than they are tall.
   
   Aims are as follows:
   Aspect ratio, ar, is window height divided by window width.
   1. 1/3 < ar < 4/3
   2. ar close to golden ratio 
   4. Want as little unused space in area as possible. 
   
   left over space is returned in the rectangle structure spare
    
*/

{ int r,c,i,j,k,top,bottom,left,right,*warea;
  double waste,golden,dx,dy,*ar;
  golden=(sqrt(5.0)-1)/2.0;
  ar=(double *)calloc((size_t)n,sizeof(double));
  warea=(int *)calloc((size_t)n,sizeof(int));
  for (r=1;r<=n;r++) // work through possible number of rows
  { c=n/r; if (c*r<n) c++; // getting number of columns
    dx=area.right-area.left;dy=area.bottom-area.top;
    warea[r-1]=(int)(dx*dy); // area of client
    dx/=c;dy/=r; // window dimensions
    ar[r-1]=dy/dx; // aspect ratio 
    if (ar[r-1]<1/3.0) // then change dx to 3 times dy
    dx=3*dy;
    if (ar[r-1]>4/3.0) // then change dy to 4/3 dx
    dy=4*dx/3;
    // now work out wasted space by subtracting window areas from client area
    warea[r-1] += - (int) (dx*dy*n); if (warea[r-1]<0) warea[r-1]=0;
  }
  /* at this stage window aspect ratios and area wasted by a tiling not exceeding 
     aspect ratio limits are  available  for all possible rectangular tilings. The
     next stage is to find a minimum wastage tiling - ties are settled by closeness to 
     golden aspect ratio */
  waste=(area.right-area.left)*(area.bottom-area.top);
  for (i=0;i<n;i++)   
  { if (warea[i]<waste) {waste=warea[i];r=i+1;} else
    if (warea[i]==waste) // then it's a tie and aspect ratios should be compared
    { if (fabs(ar[i]-golden)<fabs(ar[r-1]-golden)) 
      {waste=warea[i];r=i+1;} 
    } 
  } 
  //  so r is now the number of rows in the "best" tiling
  c=n/r; if (c*r<n) c++; // getting number of columns
  dx=area.right-area.left;dy=area.bottom-area.top;
  dx/=c;dy/=r; // window dimensions
  ar[r-1]=dy/dx; // aspect ratio 
  if (ar[r-1]<1/3.0) // then change dx to 3 times dy
  dx=3*dy;
  if (ar[r-1]>4/3.0) // then change dy to 4/3 dx
  dy=4*dx/3;
  // finally it's possible to actually work out the child window positions......
  k=0;
  spare->right=spare->left=spare->top=spare->bottom=0;
  top=area.top;
  for (i=0;i<r;i++)
  { left=area.left;bottom=area.top+(int)round((i+1)*dy);
    if (bottom>area.bottom) bottom=area.bottom;
    for (j=0;j<c;j++)
    { right=area.left+(int)round((j+1)*dx);
      if (right>area.right) right=area.right;
      pos[k].left=left;pos[k].right=right;
      pos[k].top=top;pos[k].bottom=bottom;
      left=right+1;k++;
      if (k==n&&r*c!=n) // fill out the spare structure
      { spare->top=pos[k-1].top;spare->bottom=pos[k-1].bottom;
        spare->left=pos[k-1].right+1;spare->right=area.right;
        break;
      } 
    }
    if (k==n) break;
    top=bottom+1;
  }
  free(ar);free(warea);
}

void auto_arrange(HWND parent,child_location_type *l,int type)

/* This routine attempts to arrange the child windows in some sort of sensible manner....
   A problem far more difficult, tedious and time consuming than anything else this 
   wretched program does. I'd almost (but not quite) rather surf the www or watch daytime
   tv.
*/

{ int i,j,k,n,m;
  double r,x,y,best;
  RECT area,spare;
  GetClientRect(parent,&(l->ref)); // getting dimensions of parent client area 
  if (l->ref.bottom-l->ref.top<10) return;
  if (l->p_on) // then there is a parameter window
  { if (l->n_uf) // then there are uf windows
    { i=l->ref.right-l->ref.left; // width of client area
      j=l->ref.bottom-l->ref.top; // height of client area
      r=l->n_op*3.0/(l->n_op*3.0+l->n_uf);
      if (r<1/3.0) r=1/3.0; if (r>2/3.0) r=2/3.0;
      if (type==0) // dual row layout      
      { k=(int)(r*(l->ref.bottom-l->ref.top)); // lower edge of o/p window area
      } else       // dual column mode 
      { k=l->ref.bottom; 
        if (k>(l->ref.bottom-l->ref.top)/2) k=(l->ref.bottom-l->ref.top)/2;
      }
      // compare desired size of parameter window with what is available
      if (l->param_h>k)  j=k;else j=l->param_h; // constrain param height to what's available
      if (l->param_w>i/2) i=i/2; else i=l->param_w; // make param width ok
           
      l->ploc.bottom=l->ref.top+j;l->ploc.top=l->ref.top;
      l->ploc.left=l->ref.right-i;l->ploc.right=l->ref.right;
      if (type==1) // dual column
      { if (i/(double)(l->ref.right-l->ref.left)<(1-r)) 
        i=(int)((1-r)*(l->ref.right-l->ref.left));
        if (i<(l->ref.right-l->ref.left)/3) 
        i=(l->ref.right-l->ref.left)/3;
      }  
      area=l->ref;area.right=l->ref.right-i-1;
      if (type==0) area.bottom=l->ref.top+k;
      else area.bottom=l->ref.bottom;
      tiler(area,l->oploc,&spare,l->n_op); 
      if (type==0) // dual row layout
      { area.right=l->ref.right;
        area.top=l->ref.top+k+1;
        area.bottom=l->ref.bottom;
        tiler(area,l->ufloc,&spare,l->n_uf);       
      } else // dual column layout
      { area.top=l->ploc.bottom+1;
        area.left=area.right+1;
        area.bottom=l->ref.bottom;
        area.right=l->ploc.right;
        tiler(area,l->ufloc,&spare,l->n_uf);
      }
      if (l->s_on) // look for unused space amongst the uf windows!
      { if (spare.left!=spare.right) // there is space, so put status window in it
        { x=(spare.right-spare.left)/(double)(spare.bottom-spare.top); 
          best=1e200;
          for (j=0;j<3;j++) // work through alternative status window sizes
          { y=l->status_w[j]/(double)l->status_h[j];
            if (fabs(y-x)<best) { best=fabs(y-x); i=j;}
          } // i is best match to shape of the space
          SendMessage(l->hstat,WM_COMMAND,(WPARAM)MAKELONG(i+2,0),(LPARAM)0);
          l->sloc.left=spare.left;l->sloc.top=spare.top;
          l->sloc.right=l->sloc.left+l->status_w[i];
          l->sloc.bottom=l->sloc.top+l->status_h[i];
          if (l->sloc.right>spare.right) l->sloc.right=spare.right;
          if (l->sloc.bottom>spare.bottom) l->sloc.bottom=spare.bottom; 
        } else // no spare space, need to make it elsewhere
        { if (type==0) // dual row mode
          { // need to check width of parameter column and adjust status window to match it 
            k=l->ploc.right-l->ploc.left; // width of param window
            j=2;
            for (i=0;i<3;i++)
            if (l->status_w[i]>k) { j=i-1;break;}
            if (j<0) j=0;
            SendMessage(l->hstat,WM_COMMAND,(WPARAM)MAKELONG(j+2,0),(LPARAM)0); 
            // now if k is still too small to accomodate window, then try widening available space
            if (l->status_w[j]>k)
            { k=l->status_w[j];
              i=l->ref.right-l->ref.left;i=i/2;
              if (k>i) k=i; // k is now the column width for param and status window
            } 
            
            // now deal with the height of the available area 
            i=area.top-l->ref.top-1; // height available for param and status
            if (i>l->status_h[j]+l->ploc.bottom-l->ploc.top) // then there's enough space
            { l->sloc.top=l->ploc.bottom+1;
              l->sloc.bottom=l->sloc.top+l->status_h[j];
              l->sloc.left=l->ref.right-k;
              l->sloc.right=l->sloc.left+l->status_w[j];
              if (l->sloc.right>l->ref.right) l->sloc.right=l->ref.right;
            } else // need to make space (height actually)
            { if (l->status_h[j]>i/2) n=i/2; else n=l->status_h[j]; // height of status
              m=i-n; // height of parameter window
              l->ploc.left=l->sloc.left=l->ref.right-k;
              l->ploc.top=l->ref.top;
              l->ploc.bottom=l->ploc.top+m;
              l->ploc.right=l->ref.right;
              l->sloc.top=l->ploc.bottom+1;
              l->sloc.bottom=l->sloc.top+n;
              l->sloc.right=l->ref.right;
              
              
            }
            // need to re-size plot windows.....
            area.bottom=area.top-1;
            area.top=l->ref.top;area.left=l->ref.left;
            area.right=l->ref.right-k-1;
            tiler(area,l->oploc,&spare,l->n_op);
            
          } else //dual column mode
          { // if the width of the parameter window is so much less than the width of
            // the column that status window could fit in then put them side by side
            k=area.right-area.left-(l->ploc.right-l->ploc.left); // spare width in column
            if (l->status_w[0]<k) // then there is enough spare width to fit status window
            { // see how wide status window can be made
              j=2;
              for (i=1;i<3;i++) // work through widths
              if (l->status_w[i]>k) { j=i-1;break;} // j+1 is cols in status window
              SendMessage(l->hstat,WM_COMMAND,(WPARAM)MAKELONG(j+2,0),(LPARAM)0); 
              // check depth against param window
              i=l->ploc.bottom-l->ploc.top; // param window height
              if (l->status_h[j]>i) i=l->status_h[j];
              if (i>(l->ref.bottom-l->ref.top)/2) i=(l->ref.bottom-l->ref.top)/2;
              l->sloc.left=l->ufloc[0].left;l->sloc.top=l->ploc.top;
              l->sloc.bottom=l->sloc.top+l->status_h[j];
              if (l->sloc.bottom>l->sloc.top+i) l->sloc.bottom=l->sloc.top+i;
              l->sloc.right=l->sloc.left+l->status_w[j];
              if (i!=l->ploc.bottom-l->ploc.top) // then resize uf
              { area.top=l->ref.top+i;
                tiler(area,l->ufloc,&spare,l->n_uf);
              }
            } else
            // otherwise room must be made for the status window vertically
            { // first match the width of the status windows to the width of the column
              k=area.right-area.left; // column width
              j=2;
              for (i=0;i<3;i++) // work through widths
              if (l->status_w[i]>k) { j=i-1;break;} 
              if (j<0) j=0; 
              SendMessage(l->hstat,WM_COMMAND,(WPARAM)MAKELONG(j+2,0),(LPARAM)0);
              // status window dimensions set - now work out space for param+status
              i=l->status_h[j]+l->ploc.bottom-l->ploc.top; // height required for param+status
              if (i>(l->ref.bottom-l->ref.top)/2)  // height too great need to squeeze param win
              { i=(l->ref.bottom-l->ref.top)/2;
                if (l->status_h[j]<i/2) // display full height
                { l->ploc.bottom=l->ref.top+i-l->status_h[j];
                  l->sloc.top=l->ploc.bottom;
                  l->sloc.bottom=l->ref.top+i;   
                } else // param and status have height truncated
                { l->ploc.bottom=l->ref.top+i/2;
                  l->sloc.top=l->ploc.bottom+1;
                  l->sloc.bottom=l->ref.top+i; 
                }
                l->sloc.left=area.left;
                l->sloc.right=area.left+l->status_w[j];
                if (l->sloc.right>area.right) l->sloc.right=area.right; 
              } else
              { l->sloc.left=area.left;
                l->sloc.top=l->ploc.bottom; 
                l->sloc.bottom=l->ref.top+i;
                l->sloc.right=area.left+l->status_w[j];
                if (l->sloc.right>area.right) l->sloc.right=area.right;  
              }
              // and re-locate uf windows:
              area.top=l->ref.top+i+1;
              tiler(area,l->ufloc,&spare,l->n_uf);   

            }

          }

        }

      }  
    } else // no uf windows
    { k=l->ref.right-l->ref.left; // width of client area
      j=l->ref.bottom-l->ref.top; // height of client area
      // compare desired size of parameter window with what is available
      if (l->param_h<j) j=l->param_h; // constrain param height to what's available
      if (l->s_on&&(l->param_w<l->status_w[0])) i=l->status_w[0]; else i=l->param_w;
      if (i>k/2) i=k/2; // make column width ok
      l->ploc.bottom=l->ref.top+j;l->ploc.top=l->ref.top;
      l->ploc.left=l->ref.right-i;
      l->ploc.right=l->ploc.left+l->param_w;
      if (l->ploc.right>l->ref.right) l->ploc.right=l->ref.right;
      area=l->ref;area.right=l->ref.right-i;
      tiler(area,l->oploc,&spare,l->n_op); 
      // now try and squeeze status window in
      if (l->s_on)
      { // first find status width that best matches param window width
        k=i; // column width
        j=2;
        for (i=0;i<3;i++) // work through widths
        if (l->status_w[i]>k) { j=i-1;break;} 
        if (j<0) j=0; 
        SendMessage(l->hstat,WM_COMMAND,(WPARAM)MAKELONG(j+2,0),(LPARAM)0);
        l->sloc.left=l->ploc.left;l->sloc.right=l->sloc.left+l->status_w[j];
        if (l->sloc.right>l->ref.right) l->sloc.right=l->ref.right;
        // now see if there is space for window of corresponding height
        if (l->ref.bottom-l->ploc.bottom>l->status_h[j]) // all ok
        { l->sloc.top=l->ploc.bottom;
          l->sloc.bottom=l->sloc.top+l->status_h[j];
        } else // need to squeeze parameter window
        { i=l->ref.bottom-l->ref.top; // total height available
          if (l->status_h[j]>i/2) // then need to squeeze both
          { l->ploc.bottom=l->ref.top+i/2;
            l->sloc.top=l->ploc.bottom;
            l->sloc.bottom=l->ref.bottom;
          } else
          { l->sloc.bottom=l->ref.bottom;
            l->sloc.top=l->sloc.bottom-l->status_h[j];
            l->ploc.bottom=l->sloc.top;
          } 

        }
      }
    } 
  } else // no parameter window (in which case there must be uf windows!)
  {  // filter layout option to make sure it makes sense
    if (type==0) // dual row layout
    { // decide on where to split window
      r=l->n_op*3.0/(l->n_op*3.0+l->n_uf);
      if (r<1/3.0) r=1/3.0; if (r>2/3.0) r=2/3.0;
      k=(int)(r*(l->ref.bottom-l->ref.top)); // lower edge of o/p window area
      // decide on layout of o/p windows within o/p window area
      area.top=k+1;area.bottom=l->ref.bottom;
      area.left=l->ref.left;area.right=l->ref.right;
        
      tiler(area,l->ufloc,&spare,l->n_uf);
      area.top=l->ref.top;area.bottom=k;
      tiler(area,l->oploc,&spare,l->n_op);
      if (l->s_on)
      { if (spare.left!=spare.right) // then fit status w. into spare space
        { x=(spare.right-spare.left)/(double)(spare.bottom-spare.top); 
          best=1e200;
          for (j=0;j<3;j++) // work through alternative status window sizes
          { y=l->status_w[j]/(double)l->status_h[j];
            if (fabs(y-x)<best) { best=fabs(y-x); i=j;}
          } // i is best match to shape of the space
          SendMessage(l->hstat,WM_COMMAND,(WPARAM)MAKELONG(i+2,0),(LPARAM)0);
          l->sloc.left=spare.left;l->sloc.top=spare.top;
          l->sloc.right=l->sloc.left+l->status_w[i];
          l->sloc.bottom=l->sloc.top+l->status_h[i];
          if (l->sloc.right>spare.right) l->sloc.right=spare.right;
          if (l->sloc.bottom>spare.bottom) l->sloc.bottom=spare.bottom; 
        } else // make space for status window by shoving up others 
        { SendMessage(l->hstat,WM_COMMAND,(WPARAM)MAKELONG(2,0),(LPARAM)0);
          if (l->ref.bottom-k<l->status_h[0]) // move up op windows
          { k=l->ref.bottom-l->status_h[0];
            j=(l->ref.bottom-l->ref.top)/2+l->ref.top;
            if (k<j) k=j;
          } 
          j=l->ref.right-l->status_w[0];
          i=(l->ref.right-l->ref.left)/3+l->ref.left;
          if (j<i) j=i; 
          area.top=k+1;area.bottom=l->ref.bottom;
          area.right=j-1;
          tiler(area,l->ufloc,&spare,l->n_uf);
          area.top=l->ref.top;area.bottom=k;area.right=l->ref.right;
          tiler(area,l->oploc,&spare,l->n_op);  
          l->sloc.left=j;l->sloc.right=l->ref.right;
          l->sloc.top=k+1;
          l->sloc.bottom=l->sloc.top+l->status_h[0];
          if (l->sloc.bottom>l->ref.bottom) l->sloc.bottom=l->ref.bottom;
        }
      }
    } else // dual column layout
    { r=l->n_op*3.0/(l->n_op*3.0+l->n_uf);
      if (r<1/3.0) r=1/3.0; if (r>2/3.0) r=2/3.0;
      k=(int)(r*(l->ref.right-l->ref.left)); // right edge of o/p window area
      area.top=l->ref.top;area.bottom=l->ref.bottom;
      area.right=k;area.left=l->ref.left;
      tiler(area,l->oploc,&spare,l->n_op);
      area.left=k+1;area.right=l->ref.right;
      tiler(area,l->ufloc,&spare,l->n_uf);  
      if (l->s_on) 
      { if (spare.left!=spare.right) // then put status window into the space
        { // first search for best geometry
          x=(spare.right-spare.left)/(double)(spare.bottom-spare.top); 
          best=1e200;
          for (j=0;j<3;j++) // work through alternative status window sizes
          { y=l->status_w[j]/(double)l->status_h[j];
            if (fabs(y-x)<best) { best=fabs(y-x); i=j;}
          } // i is best match to shape of the space
          SendMessage(l->hstat,WM_COMMAND,(WPARAM)MAKELONG(i+2,0),(LPARAM)0);
          l->sloc.left=spare.left;l->sloc.top=spare.top;
          l->sloc.right=l->sloc.left+l->status_w[i];
          l->sloc.bottom=l->sloc.top+l->status_h[i];
          if (l->sloc.right>spare.right) l->sloc.right=spare.right;
          if (l->sloc.bottom>spare.bottom) l->sloc.bottom=spare.bottom; 
        } else // make room for status window at column top 
        { // get geometry with closest width
          k=area.right-area.left;
          j=2;
          for (i=0;i<3;i++) if (l->status_w[i]>k) {j=i-1;break;}
          if (j<0) j=0;
          j+=2;
          SendMessage(l->hstat,WM_COMMAND,(WPARAM)MAKELONG(j,0),(LPARAM)0);
          j-=2;
          l->sloc.left=area.left;
          l->sloc.right=l->sloc.left+l->status_w[j];
          if (l->sloc.right>area.right) l->sloc.right=area.right;
          l->sloc.top=area.top;
          l->sloc.bottom=area.top+l->status_h[j];
          j=(area.bottom-area.top)/3+area.top;
          if (l->sloc.bottom>j) l->sloc.bottom=j;
          area.top=l->sloc.bottom+1;
          tiler(area,l->ufloc,&spare,l->n_uf);
        }
      }  
    }
  } 
}  



void rescaler(RECT loc,RECT ref,RECT rect,int *x,int *y,int *dx,int *dy)

/* loc is the location of a window relative to parent of location ref. If new 
   location of parent is rect, then x,y,dx,dy give location of top left along with 
   width and height */

{ *x=((loc.left-ref.left)*(rect.right-rect.left))/(ref.right-ref.left)+rect.left;
  *y=((loc.top-ref.top)*(rect.bottom-rect.top))/(ref.bottom-ref.top)+rect.top;
  *dx=((loc.right-loc.left)*(rect.right-rect.left))/(ref.right-ref.left);
  *dy=((loc.bottom-loc.top)*(rect.bottom-rect.top))/(ref.bottom-ref.top);
}

void setup_fit_control(fit_control_type *fit,parent_setup_type *set,parent_win_data_type *pwd)

/* function that sets up fit using default values supplied by user in initfit() and passed to 
   ParentWndProc() via set. All the quantities set and used here are defined in the header 
   files ddefit95.h and w95dde.h.
*/

{ int i;
  // set up the integer quantities and arrays ......
  fit->fitmethod=set->fitmethod;
  fit->error=set->errors;
  fit->gcv_method=set->gcv_method;
  // determine whether smoothing parameters need estimating
  fit->get_sp=0; 
  fit->n_p=set->n_uc; // number of params
  for (i=0;i<set->n_uf;i++) 
  { if (set->ufsp[i]<0.0) fit->get_sp=1;
    fit->n_p+=set->ufdf[i];  // total number of parameters
  }
  fit->bsr_reps=set->bsr_reps;
  fit->n_uf=set->n_uf;
  fit->n_uc=set->n_uc;
  fit->n_c=set->n_c;
  fit->n_s=set->n_s;
  fit->n_hv=set->n_hv;
  fit->n_lag=set->n_lag;
  fit->n_sw=set->n_sw;
  fit->n_fit=set->n_fit;
  fit->n_st=set->n_st; // note if this is 0 then all data are read in and this is reset
  fit->stats=set->stats;
  fit->hbsize=set->hbsize;
  fit->ufdf=set->ufdf;
  fit->uftype=set->uftype;
  fit->uctype=set->uctype;
  fit->n_dis=set->n_disv;
  fit->index=set->index;
  fit->distos=set->distos;
  fit->stodis=set->stodis; 
  fit->fitdv=set->fitdv;
  // move on to the double quantities and arrays.....
  fit->c=set->c;
  fit->t0=set->t0; // the integration as opposed to data start time fit->ts[0]
  fit->dout=set->dout; 
  fit->tol=set->tol;
  fit->ufx=set->ufx;
  fit->uflb=set->uflb;
  fit->ufub=set->ufub;
  fit->ufsp=set->ufsp;
  fit->ufspmax=set->ufspmax;
  fit->ucub=set->ucub;
  fit->uclb=set->uclb;  
  fit->wstats=set->wstats;
  fit->wfile=set->wfile;
  fit->dfile=set->dfile;
  fit->dt=set->dt;
  fit->bsc.reps=0; // initialize for no bootstrapping
  fit->y=fit->f=fit->w=(double *)NULL;
}

void prepare_fit(parent_win_data_type *pwd,fit_control_type *fit) 

/* * reads data, weights and current parameters into the fit control structure,
   * creates the status window if it doesn't yet exist
   * puts the raw data into the output windows
   * resets the x axis ranges of the output windows
*/ 
{ param_win_data_type *padata;
  winplotype *gwdata;
  int i,j,c,k;
  matrix y,w;
  double min,max,arr[2];
  if (!pwd->statusw) // then create status window
  SendMessage(pwd->hwnd,WM_COMMAND,(WPARAM)MAKELONG(99,0),(LPARAM)0); 
  // readin the data
  readin(&y,&w,fit); // y is data vector, w weight vector
  if (fit->y) free(fit->y);
  if (fit->f) free(fit->f);
  if (fit->w) free(fit->w);
  fit->y=(double *)calloc((size_t)y.r,sizeof(double));
  fit->f=(double *)calloc((size_t)y.r,sizeof(double));
  fit->w=(double *)calloc((size_t)w.r,sizeof(double));
  // NOTE: if above are freed, make sure that pointers set to NULL. 
  for (i=0;i<y.r;i++) fit->y[i]=y.V[i];
  for (i=0;i<w.r;i++) fit->w[i]=w.V[i];
  freemat(y);freemat(w);
  // send the raw data to the o/p windows for display
  // request space on raw data buffers (slightly inefficient)
  j=0;min=max=fit->raw[0][0].x;
  for (i=0;i<fit->n_fit;i++) 
  { if (j<fit->raw_n[i]) j=fit->raw_n[i]; 
    if (min>fit->raw[i][0].x) min=fit->raw[i][0].x;
    if (max<fit->raw[i][fit->raw_n[i]-1].x) max=fit->raw[i][fit->raw_n[i]-1].x; 
  }
  for (i=0;i<pwd->n_opw;i++) // request space on raw data buffers
  SendMessage(pwd->opw[i],WM_COMMAND,(WPARAM)MAKELONG(5,0),(LPARAM)j);
                     
  // now place the raw data in the graphic window data buffer
                    
  for (i=0;i<fit->n_fit;i++)
  { c=fit->index[i+1]; // the state variable for this raw variable
    c=fit->stodis[c]; // the display variable for this state variable
    if (c==-1) 
    ErrorMessage("Something is wrong with display variable mapping in prepare_fit()",1);
    k=pwd->disvw[c];   // get window number for this state variable
    // retrieve its data....
    gwdata=(winplotype *)GetWindowLong(pwd->opw[k],GWL_USERDATA); 
    k=pwd->disvc[c]; // get curve number for this state variable
    for (j=0;j<fit->raw_n[i];j++)
    { gwdata->raw[k][j].x=fit->raw[i][j].x;
      gwdata->raw[k][j].y=fit->raw[i][j].y; 
      gwdata->no_raw_points[k]++;
    }
  }  
  // Now reset x range of o/p window  and turn on raw data display
  arr[0]=min;arr[1]=max;
  for (i=0;i<pwd->n_opw;i++) 
  { SendMessage(pwd->opw[i],WM_COMMAND,(WPARAM)MAKELONG(1,0),(LPARAM)arr);
    SendMessage(pwd->opw[i],WM_COMMAND,(WPARAM)MAKELONG(6,0),(LPARAM)0);   
    SendMessage(pwd->opw[i],WM_PAINT,(WPARAM)0,(LPARAM)0);
  } 
                                    
  // load the parameter vector from the parameter and uf windows
  // first tell parameter window to update its parameter structure
  SendMessage(pwd->paramw,WM_COMMAND,(WPARAM)MAKELONG(3,0),(LPARAM)0);
  fit->p=(double *)calloc((size_t)fit->n_p,sizeof(double));
  padata=(param_win_data_type *)GetWindowLong(pwd->paramw,GWL_USERDATA); 
  for (i=0;i<fit->n_uc;i++) fit->p[i]=padata->c[i];
  fit->Vp=(double **)calloc((size_t)fit->n_p,sizeof(double *));
  for (i=0;i<fit->n_p;i++) fit->Vp[i]=(double *)calloc((size_t)fit->n_p,sizeof(double));             
  for (i=0;i<pwd->n_uf;i++) // request pwd updated with latest values
  SendMessage(pwd->ufw[i],WM_COMMAND,(WPARAM)MAKELONG(1,0),(LPARAM)0); 
  k=pwd->n_uc;
  for (i=0;i<pwd->n_uf;i++) for (j=0;j<pwd->ufdf[i];j++) 
  { fit->p[k]=pwd->ufy[i][j];k++;}  
}


void set_header(char **header)

{ header[0]="F";
  header[1]="Fi";
  header[2]="Fit";
  header[3]="Fitt";
  header[4]="Fitti";
  header[5]="Fittin";
  header[6]="Fitting";
  header[7]="Fitting .";
  header[8]="Fitting ..";
  header[9]="Fitting ...";
  header[10]="Fitting ....";
  header[11]=TITLE;
}


void setup_for_bootstrapping(parent_win_data_type *pwd,fit_control_type *fit)

/* Sets up the bootstrap control structure fit->bsc, with the information required for 
   bootstrapping. This information will then be used by the fitting thread to actually 
   perform bootstrapping. The meaning of the elements fit->bsc are given in the 
   bsctype definition in ddefit95.h, and in more detail in the routine bootstrap in 
   ddefit95.c */

{ 
  bscdefaults(pwd->n_fit,&(fit->bsc));
  inboot(&(fit->bsc)); // calling user function to set up bsc structure.
  fit->bsc.method=fit->fitmethod;
  //fit->bsc.errors=fit->errors; // not implemented yet
  
}

OPENFILENAME* OpenFileName(char *title,HWND hwnd,int save)

/* routine for getting the name of a user specified file via a standard windows dialog 
   The structure returned should be freed by freeing ofn->lpstrTitle, followed by freeing 
   ofn. On exit ofn->lpstrFile contains the string containing the path and name of the file
   to open.

   The arguments are a title for the windows dialog and the handle of the parent window. 
   If (save!=0) then the user is prompted if an existing file is selected. If save==0
   then the file must exist.
*/

{ OPENFILENAME *ofn;
  BOOL ok;
  ofn=(OPENFILENAME *)calloc((size_t)1,sizeof(OPENFILENAME));
                   ofn->lStructSize=sizeof(OPENFILENAME);
                   ofn->hwndOwner=hwnd;
                   ofn->nMaxFile=256;
                   ofn->nMaxFileTitle=0;
                   ofn->lpstrFileTitle=NULL;
                   ofn->lpstrFile=(char *)calloc((size_t)257,sizeof(char)); 
                   ofn->lpstrTitle=title;
                   if (save) ofn->Flags=OFN_OVERWRITEPROMPT;
                   else ofn->Flags=OFN_FILEMUSTEXIST;
                   if (save) ok=GetSaveFileName(ofn); // get output file name from user
                   else ok=GetOpenFileName(ofn);
  if (!ok) ofn->lpstrFile=(char *)NULL; // to signal failure to return a file name
  return(ofn);
}

LRESULT CALLBACK  ParentWndProc (HWND hwnd, UINT msg, WPARAM mp1, LPARAM mp2)

/* The function that handles messages for the parent window
   The parent has responsibility for setting up child display windows, interegating those windows
   for information, re-distributing data recieved from fitting and simulation threads, and sending
   messages to children telling them how to behave!
   
   It is assumed that the parent setup structure will not be freed after the window is created,
   as many of its arrays are used by other structures, rather than being copied.
   
*/

{ static simulation_control_type sim;
  static fit_control_type fit;
  static int fittry=0,header_count=0,simulating=0;
  static char *header[12];
  status_type *status_data;
  child_location_type *loc; 
  display_data_op_type *disd;
  parent_win_data_type *pwd;
  parent_setup_type *set;    // structure pointer to copy mp2 to
  param_setup_type *pset;
  plot_setup_type *ploset;
  param_win_data_type *padata;
  winplotype *gwdata;
  status_type *stdata;
  status_op_type *statd;
  FILE *fi;
  static FARPROC lpfnIntParamBox;
  OPENFILENAME *ofn;


  RECT rect;
  WNDCLASSEX gwclass,paramclass,ufclass,statusclass;
  char *ClassName,tname[100],error[50];
  static HINSTANCE hInstance;
  double dum=0.0,arr[2],*p,xx;
  int dx,dy,i,j,k;
  if (msg!=WM_CREATE) pwd=(parent_win_data_type *)GetWindowLong(hwnd,GWL_USERDATA);
  switch (msg)
  { case WM_CREATE :
    
    /* on entry mp2 is a pointer to set up data */
    set=(parent_setup_type *) ((CREATESTRUCT *)mp2)->lpCreateParams;
    // reset timesteps if model is discrete 
    if (is_model_discrete(0)) set->dt=1.0;
    /* create parent window data storage */
    pwd=(parent_win_data_type *)calloc(1,sizeof(parent_win_data_type));
    /* fill entries known from setup data */
    pwd->n_uf=set->n_uf;pwd->n_opw=set->n_opw;pwd->n_uc=set->n_uc;
    pwd->ufdf=set->ufdf;
    pwd->disvc=set->disvc;
    pwd->wname=set->wname;
    pwd->n_disv=set->n_disv;
    pwd->disvw=set->disvw;
    pwd->n_fit=set->n_fit;
    pwd->statusw=(HWND)NULL;
    pwd->hwnd=hwnd;
    set_header(header); // set parent header titles for progress indication
    /* create storage for other window data */
    pwd->opw=(HWND *)calloc(pwd->n_opw,sizeof(HWND));
    pwd->fitvw=(int *)calloc((size_t)pwd->n_fit,sizeof(int)); // storing information for dumping simulated data
    pwd->fitvc=(int *)calloc((size_t)pwd->n_fit,sizeof(int)); // ditto
    // now fill in fitvc and fitvw
    for (i=0;i<pwd->n_disv;i++)
    if (set->fitdv[i])
    { pwd->fitvw[set->fitdv[i]-1]=pwd->disvw[i]; // fitvw[i] is window for col i+1 fit variable in file
      pwd->fitvc[set->fitdv[i]-1]=pwd->disvc[i]; // fitvc[i] is curve for col i+1 fit var. in file
    }
    // create unknown function information in pwd
    pwd->ufx=set->ufx;
    pwd->ufy=set->ufy;
    pwd->ufxmin=(double *)calloc((size_t)pwd->n_uf,sizeof(double));
    pwd->ufxmax=(double *)calloc((size_t)pwd->n_uf,sizeof(double));
    
    // setup simulation control structure
    sim.n_uf=pwd->n_uf;
    sim.n_uc=pwd->n_uc;
    sim.n_c=set->n_c;
    sim.n_s=set->n_s;
    sim.n_lag=set->n_lag;
    sim.n_sw=set->n_sw;
    sim.n_hv=set->n_hv;
    sim.hbsize=set->hbsize;
    sim.c=(double *)calloc((size_t)sim.n_c,sizeof(double));
    for (i=0;i<sim.n_c;i++) sim.c[i]=set->c[i];
    sim.ufdf=(int *)calloc((size_t) sim.n_uf,sizeof(int));
    for (i=0;i<sim.n_uf;i++) sim.ufdf[i]=set->ufdf[i];
    sim.n_dis=set->n_disv;
    sim.distos=(int *)calloc((size_t) sim.n_s,sizeof(int));
    sim.fitdv=(int *)calloc((size_t) sim.n_s,sizeof(int));
    for (i=0;i<sim.n_dis;i++) 
    { sim.distos[i]=set->distos[i];
      sim.fitdv[i]=set->fitdv[i]; 
    } 
    k=0;for (i=0;i<sim.n_uf;i++) k+=sim.ufdf[i];k+=sim.n_uc;
    sim.p=(double *)calloc((size_t)k,sizeof(double));
    sim.t0=pwd->simt0=set->x0[0];
    sim.t1=pwd->simt1=set->x1[0];
    sim.dt=pwd->simdt=set->dt;
    sim.tol=set->tol;
    sim.parent=hwnd;
    sim.ufdf=pwd->ufdf;
    sim.ufx=pwd->ufx;
    // now set up the fit control structure fit
    setup_fit_control(&fit,set,pwd);
    fit.parent=hwnd;
    // Dialog box for simulation parameters
    lpfnIntParamBox=MakeProcInstance ((FARPROC)IntParamProc, hInstance);
    
    // preliminary storage of window data so it can be used by uf windows
    SetWindowLong(hwnd,GWL_USERDATA,(LONG)pwd); 
    SetWindowPos(hwnd,NULL,0,0,0,0,SWP_NOSIZE|SWP_NOMOVE); // purely to force above call to happen immediately
 


    /* defining the graphics window class */
    
    hInstance=(HINSTANCE)GetWindowLong(hwnd,GWL_HINSTANCE); 
    
    gwclass=define_graphics_window_class(hInstance); 
    
    if (!RegisterClassEx(&gwclass))
    { i=(int)GetLastError();
      sprintf(error,"Failed to register graphics class.Windows error code %d",i);
      ErrorMessage(error,1);
    } 
    // provide setup data for the graphics window class.....

    ploset=(plot_setup_type *)calloc(1,sizeof(plot_setup_type));
    
    for (i=0;i<pwd->n_opw;i++)   // creating the graphics windows 
    {  // calculate setup data for this particular window.
       k=0;for (j=0;j<pwd->n_disv;j++) if (pwd->disvw[j]==i) k++;
       ploset->ndisv=k;
       ploset->label=(char **)calloc((size_t)k,sizeof(char *));
       k=0;for (j=0;j<pwd->n_disv;j++) if (pwd->disvw[j]==i) {ploset->label[k]=set->label[j];k++;}
       ploset->x0=set->x0[i]; ploset->x1=set->x1[i]; 
       ploset->y0=set->y0[i]; ploset->y1=set->y1[i];
       pwd->opw[i]=CreateWindowEx(WS_EX_CONTROLPARENT,gwclass.lpszClassName,pwd->wname[i],
                     WS_MAXIMIZEBOX|WS_SIZEBOX|WS_BORDER|WS_CAPTION|
                     WS_CLIPCHILDREN | WS_CHILD |WS_CLIPSIBLINGS,
                     CW_USEDEFAULT,CW_USEDEFAULT,
                     CW_USEDEFAULT,CW_USEDEFAULT,
                     hwnd,NULL,hInstance,(LPVOID)ploset);
      ShowWindow(pwd->opw[i],SW_RESTORE);
      UpdateWindow(pwd->opw[i]);
    }
    
    /* ... and the parameter window class ... */
    // Form initialization data for parameter window in pset
    pset=(param_setup_type *)calloc(1,sizeof(param_setup_type));
    pset->nc=pwd->n_uc;
    pset->cname=(char **)calloc((size_t)pwd->n_uc,sizeof(char *));
    for (i=0;i<pwd->n_uc;i++) pset->cname[i]=set->cname[i];
    pset->c=(double *)calloc((size_t)pwd->n_uc,sizeof(double));
    for (i=0;i<pwd->n_uc;i++) pset->c[i]=set->uc[i];
    paramclass=define_parameter_window_class(hInstance); 
    
    if(!RegisterClassEx(&paramclass))  /*Parameter adjustment class */
    { i=(int)GetLastError();
      sprintf(error,"Failed to register parameter class.Windows error code %d",i);
      ErrorMessage(error,1);
    } 
    if (pwd->n_uc)
    { pwd->paramw = CreateWindowEx(WS_EX_CONTROLPARENT,paramclass.lpszClassName,"Parameters",
                  WS_MAXIMIZEBOX|WS_SIZEBOX|WS_BORDER|WS_CAPTION|/*WS_SYSMENU|*/
                  WS_VSCROLL|WS_HSCROLL|WS_CHILD|WS_CLIPSIBLINGS,
                  CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,
                  hwnd,NULL,hInstance,(LPVOID)pset);
    
      ShowWindow(pwd->paramw,SW_RESTORE);
      UpdateWindow(pwd->paramw);
    }
    /* The status window class is a minor modification of the param wnd class*/
    // Needs window memory added
    statusclass=paramclass;
    ClassName="STATUS";
    statusclass.lpfnWndProc=StatusWndProc;
    statusclass.lpszClassName=ClassName;
    statusclass.cbWndExtra=sizeof(status_type*); 
    if (!RegisterClassEx(&statusclass))
    { i=(int)GetLastError();
      sprintf(error,"Failed to register stutus class.Windows error code %d",i);
      ErrorMessage(error,1);
    }   
   
    // status window is only created when needed (WM_COMMAND 99)
 
    /* ... and finally the uf window class */
    ClassName="UFUNCTIONS";
    ufclass=statusclass;
    ufclass.cbWndExtra=sizeof(ufwindatatype*);
    ufclass.lpfnWndProc=FunctionWndProc;
    ufclass.lpszClassName=ClassName;
    
    if (!RegisterClassEx(&ufclass))
    { i=(int)GetLastError();
      sprintf(error,"Failed to register uf class.Windows error code %d",i);
      ErrorMessage(error,1);
    } 

    if (pwd->n_uf) // creating unknown function windows 
    { j=pwd->ufdf[0];
      for (i=1;i<pwd->n_uf;i++) if (j<pwd->ufdf[i]) j=pwd->ufdf[i];
      ufknotupdate(0,0,&dum,&dum,j,20,1,1);// setting up storage for window interpolation 
      jointhedots(&dum,&dum,&dum,&dum,j,1,1);

      pwd->ufw=(HWND *)calloc(pwd->n_uf,sizeof(HWND));
      for (i=0;i<pwd->n_uf;i++)   // creating the uf windows 
      { sprintf(tname,"Function %d",i);
        pwd->ufw[i]=CreateWindowEx(WS_EX_CONTROLPARENT,ClassName,tname,
                   WS_MAXIMIZEBOX|WS_SIZEBOX|WS_BORDER|WS_CAPTION|/*WS_SYSMENU|*/
                   WS_CHILD|WS_CLIPSIBLINGS,
                   CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,
                   hwnd,NULL,hInstance,(LPVOID)i);
        ShowWindow(pwd->ufw[i],SW_RESTORE);
        UpdateWindow(pwd->ufw[i]);
      }

    }
    // Now set up child window location information......
    loc= &(pwd->loc);  
    loc->p_on=pwd->n_uc;
    loc->s_on=0; // never starts visible
    loc->n_uf=pwd->n_uf;
    loc->n_op=pwd->n_opw;
    // and allocate space for location information
    if (pwd->n_uf) loc->ufloc=(RECT *)calloc((size_t)loc->n_uf,sizeof(RECT));
    loc->oploc=(RECT *)calloc((size_t)loc->n_op,sizeof(RECT));
    // obtain information about the size that the parameter window would like to be....
    if (pwd->n_uc)
    { padata=(param_win_data_type *)GetWindowLong(pwd->paramw,GWL_USERDATA);
      loc->param_h=padata->ywedge+padata->ymax+1;
      loc->param_w=padata->xwedge+padata->xmax+1;
    } // same required of status window, sometime
    loc->auto_arr=1;
    auto_arrange(hwnd,loc,0);
    
     
    // store window data
    SetWindowLong(hwnd,GWL_USERDATA,(LONG)pwd); 
    SetWindowPos(hwnd,NULL,0,0,0,0,SWP_NOSIZE|SWP_NOMOVE); // purely to force above call to happen immediately
 
	InvalidateRect(hwnd,NULL,TRUE);

    return 0;
    case WM_SIZE :   // commenting out is for debugging
    loc=&(pwd->loc);
    if (loc->auto_arr) auto_arrange(hwnd,loc,loc->auto_arr-1);
    GetClientRect(hwnd,&rect); // get actual current client size    
    if ((rect.bottom==rect.top)||(rect.left==rect.right)) return(0); // no visible client area!!
    if (pwd->n_uc) 
    { rescaler(loc->ploc,loc->ref,rect,&i,&j,&dx,&dy);
      SetWindowPos(pwd->paramw,NULL,i,j,dx,dy,SWP_SHOWWINDOW);
    } 
    if (pwd->statusw) 
    { rescaler(loc->sloc,loc->ref,rect,&i,&j,&dx,&dy);
      SetWindowPos(pwd->statusw,NULL,i,j,dx,dy,SWP_SHOWWINDOW);
    }
    SendMessage(pwd->paramw,WM_COMMAND,(WPARAM)2,(LPARAM)0);
    for (i=0;i<pwd->n_opw;i++)
    { rescaler(loc->oploc[i],loc->ref,rect,&k,&j,&dx,&dy);
      SetWindowPos(pwd->opw[i],NULL,k,j,dx,dy,SWP_SHOWWINDOW);
    }
    for (i=0;i<pwd->n_uf;i++)
    { rescaler(loc->ufloc[i],loc->ref,rect,&k,&j,&dx,&dy);
      SetWindowPos(pwd->ufw[i],NULL,k,j,dx,dy,SWP_SHOWWINDOW);
    }
    return 0;
    case WM_COMMAND :
    switch(LOWORD(mp1))
    { case(0) : // indicate to user that fitting thread is still awake
                { SendMessage(hwnd,WM_SETTEXT,(WPARAM)0,(LPARAM)header[header_count++]);
                  if (header_count>10) header_count=0;
                  break;
                } 
      case(1) : // new parameter information has arrived from the fit thread
                { p=(double *)mp2; // p is the new parameter vector
                  // unload any uc's to the parameter window 
                  if (pwd->paramw)
                  { padata=(param_win_data_type *)GetWindowLong(pwd->paramw,GWL_USERDATA); 
                    for (i=0;i<pwd->n_uc;i++) padata->c[i]=p[i];
                    SendMessage(pwd->paramw,WM_COMMAND,(WPARAM)MAKELONG(1,0),(LPARAM)0);
                  }
                  // unload uf information to the uf window
                  k=pwd->n_uc;
                  for (i=0;i<pwd->n_uf;i++)
                  { for (j=0;j<pwd->ufdf[i];j++) pwd->ufy[i][j]=p[k++];
                    SendMessage(pwd->ufw[i],WM_COMMAND,(WPARAM)MAKELONG(3,0),(LPARAM)0); 
                  }
                  free(p);
                  break;
                }
      case(2) : // status information arrived for display
                { if (pwd->statusw) // then there is some point in proceeding!
                  { statd=(status_op_type *)mp2; // status info sent for display
                    status_data=(status_type *)GetWindowLong(pwd->statusw,GWL_USERDATA); 
                    status_data->cons=statd->cons;
                    status_data->obj=statd->F;
                    status_data->dobj=statd->dF;
                    // ... so data all placed directly in the status windows data structure
                    free(statd);
                    SendMessage(pwd->statusw,WM_COMMAND,(WPARAM)1,(LPARAM)0);
                  }
                  break;
                }

      case(3) : { disd=(display_data_op_type *)mp2; // state variable data sent for display
                  for (i=0;i<pwd->n_opw;i++) // request space on buffer
                  SendMessage(pwd->opw[i],WM_COMMAND,(WPARAM)MAKELONG(4,0),(LPARAM)disd->n_t);
                  for (i=0;i<pwd->n_disv;i++) // place data in window data buffer
                  { k=pwd->disvw[i];
                    gwdata=(winplotype *)GetWindowLong(pwd->opw[k],GWL_USERDATA); 
                    k=pwd->disvc[i];
                    for (j=0;j<disd->n_t;j++)
                    { gwdata->data[k][j].x=(float)disd->t[j];
                      gwdata->data[k][j].y=(float)disd->display[i][j]; 
                    }
                  } 
                  for (i=0;i<pwd->n_opw;i++) // tell windows to update
                  SendMessage(pwd->opw[i],WM_PAINT,(WPARAM)0,(LPARAM)0);
                  for (i=0;i<pwd->n_uf;i++)
                  { pwd->ufxmin[i]=disd->ufxmin[i];
                    pwd->ufxmax[i]=disd->ufxmax[i];
                  } 
                  for (i=0;i<pwd->n_uf;i++) 
                  SendMessage(pwd->ufw[i],WM_COMMAND,(WPARAM)MAKELONG(3,0),(LPARAM)0);
                  
                  // now free the memory associated with disd
                  free_display_data_op_type(disd);  
                  break;
                } 
      case(4) : { disd=(display_data_op_type *)mp2; // noisy data arrived from simulation thread
                  if (pwd->simnoise>0.0) // then display output data
                  { // request space on raw data buffers
                    for (i=0;i<pwd->n_opw;i++) // request space on raw data buffers
                    SendMessage(pwd->opw[i],WM_COMMAND,(WPARAM)MAKELONG(5,0),(LPARAM)disd->n_t);
                     
                    // now place the simulated data in the graphic window data buffer
                    
                    for (i=0;i<pwd->n_disv;i++) // place data in window data buffer
                    if (sim.fitdv[i])
                    { k=pwd->disvw[i];
                      gwdata=(winplotype *)GetWindowLong(pwd->opw[k],GWL_USERDATA); 
                      k=pwd->disvc[i];
                      gwdata->no_raw_points[k]=0;
                      for (j=0;j<disd->n_t;j++)
                      { gwdata->raw[k][j].x=(float)disd->t[j];
                        gwdata->raw[k][j].y=(float)disd->display[i][j]; 
                        gwdata->no_raw_points[k]++;
                      }
                    }
                                     
                    for (i=0;i<pwd->n_opw;i++) // and turn on raw data display
                    { SendMessage(pwd->opw[i],WM_COMMAND,(WPARAM)MAKELONG(6,0),(LPARAM)0);   
                      SendMessage(pwd->opw[i],WM_PAINT,(WPARAM)0,(LPARAM)0);
                    } 
                  }
                  free_display_data_op_type(disd);
                  break;
                }
      case 10 : // a child has been resized by the user - store all window positions
                // see uf window procedure for how to send message (needs WM_SIZING and WM_MOVING)
               { loc= &(pwd->loc);
                  loc->auto_arr=0; // user arrangement used from now on
                  GetClientRect(hwnd,&rect); // location of parameter window on screen
                  loc->ref=rect;  
                  if (loc->p_on)
                  { GetChildRect(pwd->paramw,&rect); // location of parameter window on screen
                    loc->ploc=rect;
                  }
                  if (loc->s_on)
                  { GetChildRect(pwd->statusw,&rect); // location of parameter window on screen
                    loc->sloc=rect;
                  }
                  for (i=0;i<loc->n_uf;i++)
                  { GetChildRect(pwd->ufw[i],&rect); // location of parameter window on screen
                    loc->ufloc[i]=rect;
                  }
                  for (i=0;i<loc->n_op;i++)
                  { GetChildRect(pwd->opw[i],&rect); // location of parameter window on screen
                    loc->oploc[i]=rect;
                  } 
                  break;
                } 
      case 21: // user has requested auto-arrangement option 0
               { loc= &(pwd->loc);
                 loc->auto_arr=1;
                 auto_arrange(hwnd,loc,loc->auto_arr-1);
                 PostMessage(hwnd,WM_SIZE,(WPARAM)0,(LPARAM)0);
                 break;
               } 
      case 22: // user has requested auto-arrangement option 1
               { loc= &(pwd->loc);
                 loc->auto_arr=2;
                 auto_arrange(hwnd,loc,loc->auto_arr-1);
                 PostMessage(hwnd,WM_SIZE,(WPARAM)0,(LPARAM)0);
                 break;
               } 
      case 98: // destroy status window - eg when simulating
               { if (pwd->statusw)
                 { loc=&(pwd->loc);loc->s_on=0;
                   DestroyWindow(pwd->statusw);
                   pwd->statusw=(HWND)NULL;
                 } 
                 break;
               }
      case 99: // create status window - usually when starting trials or fitting
               { if (!pwd->statusw) // checking it doesn't exist
                 { pwd->statusw= CreateWindowEx(WS_EX_CONTROLPARENT,"STATUS","Status",
                   WS_BORDER|WS_CAPTION|WS_MAXIMIZEBOX|WS_SIZEBOX|
                   WS_VSCROLL|WS_HSCROLL|WS_CHILD|WS_CLIPSIBLINGS,
                   CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,
                   hwnd,NULL,hInstance,NULL);
                   // fill in parts of its location onformation
                   loc=&(pwd->loc);
                   loc->hstat=pwd->statusw;
                   loc->s_on=1;
                   for (i=2;i>=0;i--)
                   { SendMessage(pwd->statusw,WM_COMMAND,(WPARAM)MAKELONG(i+2,0),(LPARAM)0);
                     stdata=(status_type *)GetWindowLong(pwd->statusw,GWL_USERDATA);
                     loc->status_h[i]=stdata->ymax+stdata->ywedge;
                     loc->status_w[i]=stdata->xmax+stdata->xwedge;
                   }  
                   if (loc->auto_arr==1) PostMessage(hwnd,WM_COMMAND,(WPARAM)MAKELONG(21,0),0);
                   else
                   if (loc->auto_arr==2) PostMessage(hwnd,WM_COMMAND,(WPARAM)MAKELONG(22,0),0);
                 }    
                 break;
               }  
      case 101 : // set simulation parameters
                 { 

                   DialogBoxParam(hInstance,"SimParam",hwnd,(DLGPROC)lpfnIntParamBox,(LPARAM)hwnd); 
  	               // may involve x-axis change
	               arr[0]=pwd->simt0;arr[1]=pwd->simt1;
                   for (i=0;i<pwd->n_opw;i++) // request x axis change
                   { SendMessage(pwd->opw[i],WM_COMMAND,(WPARAM)MAKELONG(1,0),(LPARAM)arr);
                     if (pwd->simnoise>0.0) // turn on raw data display
                     SendMessage(pwd->opw[i],WM_COMMAND,(WPARAM)MAKELONG(6,0),(LPARAM)arr);
                     else // turn off raw data display
                     SendMessage(pwd->opw[i],WM_COMMAND,(WPARAM)MAKELONG(7,0),(LPARAM)arr);
                   } 
                   PostMessage(hwnd,WM_COMMAND,(WPARAM)MAKELONG(102,0),(LPARAM)0); 
                   return 0;
                   
                  break;
                 } 

      case 102 :  // simulate 
                 { // request latest paramters
                   if (fittry) 
                   { ErrorMessage("You can't simulate while fitting, sorry.",0);
                     break;
                   }
                   if (simulating) 
                   { ErrorMessage("You are already simulating.",0);
                     break;
                   }
                   if (pwd->statusw) // then destroy status window
                   SendMessage(hwnd,WM_COMMAND,(WPARAM)MAKELONG(98,0),(LPARAM)0); 
                   pwd->sim=1;
                   SendMessage(pwd->paramw,WM_COMMAND,(WPARAM)MAKELONG(3,0),(LPARAM)0); 
                   // update simulation control parameters
                   sim.dt=pwd->simdt;arr[0]=sim.t0=pwd->simt0;
                   arr[1]=sim.t1=pwd->simt1;sim.noise=pwd->simnoise;
                   // turn off any raw data display and reset x ranges
                   
                   for (i=0;i<pwd->n_opw;i++) 
                   { SendMessage(pwd->opw[i],WM_COMMAND,(WPARAM)MAKELONG(1,0),(LPARAM)arr);
                     SendMessage(pwd->opw[i],WM_COMMAND,(WPARAM)MAKELONG(7,0),(LPARAM)0);                        
                   } 
                   // read latest parameters from windows data 
                   padata=(param_win_data_type *)GetWindowLong(pwd->paramw,GWL_USERDATA); 
                   for (i=0;i<sim.n_uc;i++) sim.p[i]=padata->c[i];
               
                   for (i=0;i<pwd->n_uf;i++) // request pwd updated with latest values
                   SendMessage(pwd->ufw[i],WM_COMMAND,(WPARAM)MAKELONG(1,0),(LPARAM)0); 
                   k=pwd->n_uc;
                   for (i=0;i<pwd->n_uf;i++) for (j=0;j<pwd->ufdf[i];j++) 
                   { sim.p[k]=pwd->ufy[i][j];k++;}
                   simulating=1;
                   _beginthread(simulation,0,&sim); 
                   break; 
                 }
      case 103 : // output a simulation to file
                 { if (fittry)
                   { ErrorMessage("You are currently fitting.",0);break;
                   } 
                   if (simulating)
                   { ErrorMessage("You are currently in mid- simulation",0);break;
                   } 
                   if (pwd->sim==0)
                   { ErrorMessage("You haven't simulated anything to output yet.",0);break;}
                   if (pwd->n_fit==0)
                   { ErrorMessage("You haven't specified any variables as fit variables in the model definition, so there's nothing to output.",0);break;}
                  
                   ofn=OpenFileName("Simulated Data Output File",hwnd,1); // get file name
                   /* now output the raw data that the user has produced 
                      to the file that they have specified. This must be done 
                      in such a way that when the data are read in for fitting 
                      they appear exactly where they were when simulated!! */ 
                   if (ofn->lpstrFile) // then user did select a valid filename
                   { fi=fopen(ofn->lpstrFile,"wt");
                     gwdata=(winplotype *)GetWindowLong(pwd->opw[pwd->fitvw[0]],GWL_USERDATA);
                     if (sim.noise>0.0) k=gwdata->no_raw_points[pwd->fitvc[0]];
                     else k=gwdata->n;
                   
                     for (i=0;i<k;i++)
                     { if (i) fprintf(fi,"\n");
                       for (j=0;j<pwd->n_fit;j++)
                       { gwdata=(winplotype *)GetWindowLong(pwd->opw[pwd->fitvw[j]],GWL_USERDATA);
                         if (sim.noise>0.0)
                         { if (j==0) // print the time
                           fprintf(fi,"%14.8g",gwdata->raw[pwd->fitvc[j]][i].x);
                           fprintf(fi,"  %14.8g",gwdata->raw[pwd->fitvc[j]][i].y);
                         } else // output noise free stuff
                         { if (j==0) // print the time
                           fprintf(fi,"%14.8g",gwdata->data[pwd->fitvc[j]][i].x);
                           fprintf(fi,"  %14.8g",gwdata->data[pwd->fitvc[j]][i].y);
                         }   
                       }
                     }     
                     fclose(fi);
                     free(ofn->lpstrFile);
                   }
                   free(ofn); // free filename structure
                   break;
                 }
         case 104: // simulation finished
                 { simulating=0;
                   break;
                 }
         case 110: // try button pressed
                 { if (fittry) break; // already running trial
                   if (simulating) 
                   { ErrorMessage("Already running trial. Wait until it's finished or press stop.",0);
                     break;
                   } 
                   fittry=1;
                   fit.trial=1;
                   fit.bsc.reps=0; // ensure no bootstrapping
                   prepare_fit(pwd,&fit);
                   // ..... and finally run the fit thread to perform one trial
                   _beginthread(fit_thread,0,(PVOID)&fit);
                   
                   break;
                 }
         case 111: // trial finished 
                 { 
                   stop_the_fit=0;
                   fittry=0; // signalling window to stop ignoring fit/trial requests
                   break;
                 }  
         case 119: // Bootstrap selected from Fit menu
                 { // Need to initialise the bootstrap control structure in the fit structure
                   if (fittry) break; // already fitting or trying 
                   fit.trial=0;fittry=1;
                   prepare_fit(pwd,&fit);
                   setup_for_bootstrapping(pwd,&fit);
                    _beginthread(fit_thread,0,(PVOID)&fit);
                   // NOTE: no clearing up of fit.bsc memory yet
                   break; 
                 }  
         case 120: // Go selected from fit menu
                 { if (fittry) break; // already fitting or trying 
                   if (simulating)
                   { ErrorMessage("You are currently simulating.",0);
                     break;
                   }   
                   fit.trial=0;fittry=1;
                   fit.bsc.reps=0; // ensure no bootstrapping
                   prepare_fit(pwd,&fit);
                   _beginthread(fit_thread,0,(PVOID)&fit);                 
                   break;
                 }
         case 121: // fit finished 
                 { fittry=0;stop_the_fit=0;
                   SendMessage(hwnd,WM_SETTEXT,(WPARAM)0,(LPARAM)header[11]); 
                   break;
                 }  
         case 130: // read parameters and send them to the relevant windows
                 { ofn=OpenFileName("Parameter Input File",hwnd,0); // get file name
                   if (!ofn->lpstrFile) { free(ofn); break;} // user failed to select valid file
                   fi=fopen(ofn->lpstrFile,"rt");
                   if (pwd->paramw)
                   { padata=(param_win_data_type *)GetWindowLong(pwd->paramw,GWL_USERDATA); 
                     for (i=0;i<pwd->n_uc;i++) 
                     { if (feof(fi)) break;
                       fscanf(fi,"%lf",&xx);
                       padata->c[i]=xx;
                     } 
                     if (feof(fi)&&(i<pwd->n_uc))
                     { ErrorMessage("File ended before all parameters read!",0);
                     }  
                     SendMessage(pwd->paramw,WM_COMMAND,(WPARAM)MAKELONG(1,0),(LPARAM)0);
                   }
                   // unload uf information to the uf window
                   k=pwd->n_uc;
                   for (i=0;i<pwd->n_uf;i++)
                   { for (j=0;j<pwd->ufdf[i];j++) 
                     { if (feof(fi)) break;
                       fscanf(fi,"%lf",&xx);
                       pwd->ufy[i][j]=xx;
                     } 
                     if (feof(fi)&&(j<pwd->ufdf[i]))
                     { ErrorMessage("File ended before all uf parameters read",0);
                     } 
                     SendMessage(pwd->ufw[i],WM_COMMAND,(WPARAM)MAKELONG(3,0),(LPARAM)0); 
                   }                   

                   fclose(fi);
                   free(ofn->lpstrFile);free(ofn);
                   break;
                 } 
         case 131: // write parameters having read them from the relevant windows
                 { ofn=OpenFileName("Parameter Input File",hwnd,1); // get file name
                   if (!ofn->lpstrFile) {free(ofn);break;} // user cancelled or something 
                   fi=fopen(ofn->lpstrFile,"wt");
                   // make sure current edit window values are in param window data structure
                   SendMessage(pwd->paramw,WM_COMMAND,(WPARAM)MAKELONG(3,0),(LPARAM)0); 
                  
                   // read latest parameters from param window data 
                   padata=(param_win_data_type *)GetWindowLong(pwd->paramw,GWL_USERDATA); 
                   for (i=0;i<pwd->n_uc;i++) 
                   { if (i) fprintf(fi,"\n");
                     fprintf(fi,"%22.15g",padata->c[i]);
                   }
               
                   for (i=0;i<pwd->n_uf;i++) // request pwd updated with latest values
                   SendMessage(pwd->ufw[i],WM_COMMAND,(WPARAM)MAKELONG(1,0),(LPARAM)0); 
                   // ... and write this data out to file ....
                   for (i=0;i<pwd->n_uf;i++) for (j=0;j<pwd->ufdf[i];j++) 
                   { fprintf(fi,"\n%22.15g",pwd->ufy[i][j]);}                   
                   fclose(fi); 
                   free(ofn->lpstrFile);free(ofn);  // clear up                 
                   break;
                 }
         case 132: // User has requested that fit be output
                 { if (pwd->sim||!(fit.f)) // check that there is something to output
                   { ErrorMessage("You don't have a fit displayed to output.",0);break;}
                   ofn=OpenFileName("Fit output file",hwnd,1); // get file name
                   if (!ofn->lpstrFile) {free(ofn);break;} // user cancelled or something 
                   outputfit(&fit,(char *)ofn->lpstrFile);
                   free(ofn->lpstrFile);free(ofn);  // clear up   
                   break;
                 }
         case 133: // user has requested r^2 output
                 { if (pwd->sim||!(fit.f)) // check that there is something to output
                   { ErrorMessage("No fit available for r-squared calculation.",0);break;}
                   ofn=OpenFileName("R-squared output file",hwnd,1); // get file name
                   if (!ofn->lpstrFile) {free(ofn);break;} // user cancelled or something 
                   output_r2(&fit,(char *)ofn->lpstrFile,(double)fit.n-fit.edf); 
                   free(ofn->lpstrFile);free(ofn);  // clear up   
                   break;
                 }
         case 135: // output covariance/correlation matrix
                 { if (pwd->sim||!(fit.f)) // check that there is something to output
                   { ErrorMessage("No fit available for covariance calculation.",0);break;}
                   ofn=OpenFileName("Estimated parameter cov/cor matrix output file",hwnd,1); // get file name
                   if (!ofn->lpstrFile) {free(ofn);break;} // user cancelled or something 
                   fi=fopen(ofn->lpstrFile,"wt");
                   for (i=0;i<fit.n_p;i++) 
                   { if (i) fprintf(fi,"\n");
                     for (j=0;j<i;j++) // correlations below the leading diagonal
                     { xx=fit.Vp[i][i]*fit.Vp[j][j];
                       
                       if (xx>0.0) xx=fit.Vp[i][j]/sqrt(xx);
                       fprintf(fi," %11.4g",xx);
                     }  
                     for (j=i;j<fit.n_p;j++) // covariances on and above leading diagonal
                     { xx=fit.Vp[i][j];
                       fprintf(fi," %11.4g",xx);
                     }
                   }
                   fclose(fi); 
                   free(ofn->lpstrFile);free(ofn);  // clear up   
                   break;
                 }
         
         case 136: // output standard errors 
                 { if (pwd->sim||!(fit.f)) // check that there is something to output
                   { ErrorMessage("No fit available for variance calculation.",0);break;}
                   
                   { ofn=OpenFileName("Parameter estimate + standard error output file",hwnd,1); // get file name
                     if (!ofn->lpstrFile) {free(ofn);break;} // user cancelled or something 
                     fi=fopen(ofn->lpstrFile,"wt");
                     padata=(param_win_data_type *)GetWindowLong(pwd->paramw,GWL_USERDATA); 
                     fprintf(fi,"   Estimate     Standard Deviation    Name\n");                  
                     for (i=0;i<fit.n_uc;i++)
                     fprintf(fi,"\n%11.4g            %11.4g    %s",fit.p[i],sqrt(fit.Vp[i][i]),padata->cname[i]);
                     k=fit.n_uc;
                     for (i=0;i<fit.n_uf;i++)
                     for (j=0;j<fit.ufdf[i];j++)
                     if (!j)  
                     { fprintf(fi,"\n%11.4g            %11.4g    uf %d",fit.p[k],sqrt(fit.Vp[k][k]),i);k++;}
                     else
                     { fprintf(fi,"\n%11.4g            %11.4g",fit.p[k],sqrt(fit.Vp[k][k]));k++;}
                     fclose(fi);
                   }
                   if (fit.n_uf)
                   { ofn=OpenFileName("Unknown function estimate + standard error output file",hwnd,1); // get file name
                     if (!ofn->lpstrFile) {free(ofn);break;} // user cancelled or something 
                     WriteUF(pwd,&fit,(char *)ofn->lpstrFile);
                   }
                   free(ofn->lpstrFile);free(ofn);  // clear up   
                   break;
                 }     
         case 199: // user has pressed the stop button to terminate a trial or fit
                 { if (fittry) stop_the_fit=1;
                   break;
                 }
         
    }  
    return(0); 
    case WM_DESTROY:
    PostQuitMessage(0);
    return(0);
  }
  return DefWindowProc (hwnd,msg,mp1,mp2);

}



void get_setup_information(parent_setup_type *set)

/* This routine calls the user modified function initfit() in order to obtain information
   about the desired format of output for passing to the parent window.
   
   The arrays in set are re-initialized for effecient storage, since the arrays in dfc are
   all oversized.
 
   Currently preliminary to allow testing of re-engineered parent etc.
   
   Eventually it will fully interrogate dfc.
*/

{ ddefit_control dfc;
  int i,j,k;
  dfc=initddefit_control(MAX_CO,MAX_FUNC,MAX_VAR); // initialize ddefit control structure
  initfit(&dfc);
  if (dfc.discrete) 
  { ddep=ddem;is_model_discrete(1);
  } else 
  { ddep=dde;is_model_discrete(2);
  }
  set->n_uf=dfc.no_uf;
  set->n_uc=dfc.no_uc;
  set->cname=(char **)calloc((size_t)set->n_uc,sizeof(char *));
  for (i=0;i<set->n_uc;i++) set->cname[i]=dfc.cname[i];
  set->ufdf=(int *)calloc((size_t)set->n_uf,sizeof(int));
  for (i=0;i<set->n_uf;i++) set->ufdf[i]=dfc.ufdf[i];
  // process dfc.windex to establish which display variables go where
  k=0;set->n_opw=0;
  for (i=0;i<dfc.no_s;i++) 
  if ((dfc.windex[i].cur>=0)&&(dfc.windex[i].win>-1)) // count display variables and number of graphic windows
  { k++;
    if (dfc.windex[i].win>set->n_opw) set->n_opw=dfc.windex[i].win; 
  } 
  if (k>0) set->n_opw++;
  set->label=(char **)calloc((size_t)k,sizeof(char *));
  set->disvc=(int *)calloc((size_t)k,sizeof(int));
  set->disvw=(int *)calloc((size_t)k,sizeof(int));
  set->distos=(int *)calloc((size_t)k,sizeof(int));
  set->fitdv=(int *)calloc((size_t)k,sizeof(int));
  k=0;
  set->n_fit=dfc.no_fit;
  for (i=0;i<dfc.no_s;i++) 
  if ((dfc.windex[i].cur>=0)&&(dfc.windex[i].win>-1))
  { set->disvc[k]=dfc.windex[i].cur; // curve number for kth display var
    set->disvw[k]=dfc.windex[i].win; // window number for kth display var  
    set->label[k]=dfc.label[i];      // label for kth display var
    set->distos[k]=i;                // state variable for kth display var
    for (j=0;j<dfc.no_fit;j++)       // determine whether there is a fit var for this display var 
    if (dfc.index[j+1]==i) { set->fitdv[k]=j+1;break;}  // and record column of data file it's in
    k++;
  }
  
  set->n_disv=k;
  // set up array giving display variable for ith state variable (-1) for none
  set->stodis=(int *)calloc((size_t)dfc.no_s,sizeof(int)); 
  for (i=0;i<dfc.no_s;i++) set->stodis[i] = -1;
  for (i=0;i<set->n_disv;i++) set->stodis[set->distos[i]]=i;
  // It would be a good idea to put in a check for duplicates etc about here
  
  // now set up graphics window names....
  set->wname=(char **)calloc((size_t)set->n_opw,sizeof(char *));
  for (i=0;i<set->n_opw;i++) set->wname[i]=dfc.wname[i];
  // copy across initial parameter values....
  set->uc=(double *)calloc((size_t)set->n_uc,sizeof(double));
  for (i=0;i<set->n_uc;i++) set->uc[i]=dfc.uco[i];   
  // and set up unknown function information
  set->ufx=(double **)calloc((size_t) set->n_uf,sizeof(double *));
  set->ufy=(double **)calloc((size_t) set->n_uf,sizeof(double *));
  for (i=0;i<set->n_uf;i++)
  { set->ufx[i]=(double *)calloc((size_t) set->ufdf[i],sizeof(double));
    set->ufy[i]=(double *)calloc((size_t) set->ufdf[i],sizeof(double));
    ufsetup(set->ufx[i],set->ufy[i],dfc.uft0[i],dfc.uft1[i],dfc.ufdf[i],i);
  }
  // default axis limits for graphic windows
  set->x0=(double *)calloc((size_t)set->n_opw,sizeof(double));
  set->x1=(double *)calloc((size_t)set->n_opw,sizeof(double));
  set->y0=(double *)calloc((size_t)set->n_opw,sizeof(double));
  set->y1=(double *)calloc((size_t)set->n_opw,sizeof(double));
  for (i=0;i<set->n_opw;i++)
  { set->x0[i]=dfc.t0;set->x1[i]=dfc.t1;
    set->y0[i]=dfc.range[i].y0;set->y1[i]=dfc.range[i].y1;
  }
  // model solution information ....
  set->dt=dfc.dout;
  set->hbsize=dfc.hbsize;
  set->n_c=dfc.no_c;
  set->n_hv=dfc.no_hv;
  set->n_lag=dfc.nlag;
  set->n_s=dfc.no_s;
  set->n_sw=dfc.no_sw;
  set->tol=dfc.tol;
  set->c=(double *)calloc((size_t)set->n_c,sizeof(double));
  for (i=0;i<set->n_c;i++) set->c[i]=dfc.c[i];
  set->dfile=dfc.dfile;
  set->wfile=dfc.wfile;
  set->dout=dfc.dout;
  set->t0=dfc.t0;
  set->fitmethod=dfc.fitmethod;
  set->errors=dfc.errors;
  set->gcv_method=dfc.gcvmethod;
  set->bsr_reps=dfc.bsr_reps;
  set->stats=dfc.statistics;
  set->n_st=dfc.rows;
  // various arrays of length set->n_uf
  set->uftype=(int *)calloc((size_t)set->n_uf,sizeof(int));
  set->ufsp=(double *)calloc((size_t)set->n_uf,sizeof(double));
  set->ufspmax=(double *)calloc((size_t)set->n_uf,sizeof(double));
  set->ufub=(double *)calloc((size_t)set->n_uf,sizeof(double));
  set->uflb=(double *)calloc((size_t)set->n_uf,sizeof(double));
  set->re_vmax=(double *)calloc((size_t)set->n_uf,sizeof(double));
  for (i=0;i<set->n_uf;i++) 
  { set->uftype[i]=dfc.uftype[i];
    set->uflb[i]=dfc.uflb[i];
    set->ufub[i]=dfc.ufub[i];
    set->ufsp[i]=dfc.ufsp[i];
    set->ufspmax[i]=dfc.ufspmax[i];
    set->re_vmax[i]=dfc.revmax[i];
  }
  // arrays of length set->n_uc
  set->uctype=(int *)calloc((size_t)set->n_uc,sizeof(int));
  set->uclb=(double *)calloc((size_t)set->n_uc,sizeof(double));
  set->ucub=(double *)calloc((size_t)set->n_uc,sizeof(double));
  for (i=0;i<set->n_uc;i++) 
  { set->uctype[i]=dfc.uctype[i];
    set->uclb[i]=dfc.uclb[i];
    set->ucub[i]=dfc.ucub[i];
  } 
  // set up weights on statistics
  set->wstats=(double *)calloc((size_t)MAXSTAT+1,sizeof(double));
  for (i=0;i<MAXSTAT+1;i++) set->wstats[i]=dfc.wstats[i];
  set->index=(int *)calloc((size_t)set->n_fit+1,sizeof(int));
  for (i=0;i<set->n_fit+1;i++) set->index[i]=dfc.index[i];
  freeddefit_control(dfc); // freeing the dynamic memory associated with dfc
}



int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
           PSTR szCmdLine, int iCmdShow)

/* Main procedure for the output thread, which is also the main thread
*/

{ HWND hwndp;
  MSG msg;
  parent_setup_type *set; 
  WNDCLASSEX paclass;
  char *ClassName,*Title,error[200];
  int i;
 
  ClassName="PARENT";
  set=(parent_setup_type *)calloc(1,sizeof(parent_setup_type));

  get_setup_information(set); // initialize and fill parent setup info structure 

  Title=TITLE; 
 
  /* defining the parent window class */
  paclass.cbSize=sizeof(paclass);
  paclass.style=CS_HREDRAW|CS_VREDRAW;
  paclass.lpszClassName=ClassName;
  paclass.hInstance=hInstance;
  paclass.lpfnWndProc=ParentWndProc;
  paclass.hCursor=LoadCursor(NULL,IDC_ARROW);
  paclass.hIcon=LoadIcon(NULL,IDI_APPLICATION);//hInstance,"#5");
  paclass.hIconSm=LoadIcon(NULL,IDI_APPLICATION);//(hInstance,"#5");
  paclass.lpszMenuName="ddeMenu";
  paclass.hbrBackground=(HBRUSH) GetStockObject(GRAY_BRUSH);
  paclass.cbWndExtra=sizeof(parent_win_data_type*); // window memory
  paclass.cbClsExtra=0;


  if (!RegisterClassEx(&paclass))
  { i=(int)GetLastError();
    sprintf(error,"Failed to register class.Windows error code %d",i);
    ErrorMessage(error,1);
  } 

  hwndp=CreateWindowEx(WS_EX_CONTROLPARENT,(LPCTSTR)ClassName,(LPCTSTR )Title,
                     WS_CLIPCHILDREN |WS_OVERLAPPEDWINDOW,
                     CW_USEDEFAULT,CW_USEDEFAULT,
                     CW_USEDEFAULT,CW_USEDEFAULT,
                     NULL,NULL,hInstance,(LPVOID)set);
  
  if (!hwndp) // failed to create parent window
  { i=(int)GetLastError();
    sprintf(error,"Failed to create application Window.Windows error code %d",i);
    ErrorMessage(error,1);
    
  }

  ShowWindow(hwndp,iCmdShow);
  UpdateWindow(hwndp);

  
  while (GetMessage(&msg,NULL,0,0))
  { TranslateMessage(&msg);
    DispatchMessage(&msg);

  }
  return(msg.wParam);
}

