/* This is w95dde.h - it contains function prototypes and definitions of structures used 
   to pass information around the user interface thread of DDEfit */

#define STRICT
#include <process.h>
#include <windows.h>
#ifndef DDEFIT_HEADER_IN
typedef struct
{ float x,y;} xytype;

typedef struct
{ int win,cur;} wctype;
#endif


typedef struct   // structure that holds graphics window data. * is internal
{ xytype **data,  // display variable data for ploting as continuous curves
	     *buffer, // last output - redundant
	     **raw;   // data to plot as discrete points. NOTE: xytype.x and .y are floats
  double x0,      // minimum x value
         x1,      // maximum x value
         y0,      // minimum y value
         y1,      // maximum y value
         dy,      // * y scale increment
         dx,      // * x scale increment
        exx,      // * for storing x labels in exponential notation
        exy,       // * for storing y labels in exponential notation
        sfx,      // * for storing x labels in exponential notation
        sfy;      // * for storing y labels in exponential notation
  char **label,   // plot variable labels
     lolabx[20],  // the following are all axis labels formatted for display
     hilabx[20],
     exlabx[20],
     lolaby[20],
     hilaby[20],
     exlaby[20],
         *wname;  // window name
  int *color,     // * list of colors to plot lines and data in
           n,     // number of points in "continuous" curves
    datasize,     // * number of elements of memory allocated for each continuous curve
        nvar,     // number of continuous variables to plot
     newaxes,     // * set to one when new axes are needed
      resize,     // * set to 1 to signal need for 
      offset,     // 
          ny,    
          nx,
       width,
      height,
         llx,
         lly,
         urx,
         ury,
   headwidth,   // total width of plot header info
    headcols,   // number of columns in header
    headrows,   // number of rows in headed
    plot_raw,   // set to 1 to plot any raw data, and to zero not to
    paintcount, // used to decide when to erase old traces
    raw_alloc,  // elements actually allocated for each raw variable
  *no_raw_points; // number of raw data points
  HWND hwndb,
      hwndbc; /*scale control button handle  */
  float left,
       right,
         top,
       bottom;
  HFONT hFont; // font used in this window
} winplotype;

typedef struct
{ int ndisv; // number of display variables
  double x0,    // lower x axis limit
         x1,    // upper x axis limit
         y0,    // lower y axis limit
         y1;    // upper y axis limit
  char **label; // label[i] is name for plot variable i
} plot_setup_type;

typedef struct
{ HANDLE hEvent;
  int sim;
} PARAMS, *PPARAMS;


typedef struct
{ int id, /* Which unknown function is it ? */
  df,mesh,  /* df of the uf, every mesh knots is moveable by the window */
  nak,      /* number of active knots */
  *ix0,*ix1,*iy0,*iy1, /* window co-ord positions of active knots */
  moving,             /* indicator that  a point is moving */
  nx,ny;  /* number of points on axes scales */
  double x0,x1,y0,y1, /* max and min on x and y  axes */
	 *xk,*yk,    /* arrays for knot positions */
	 *x,*y,      /* and for storing interpolated values */
    dx,dy,exx,exy,xm,ym, /* axes information */
    xmin,xmax;   /* the range of input values passed to the function */
  HWND rsbhwnd; /* handle for rescale button */
  float left,right,top,bottom; /* position of window relative to parent */
} ufwindatatype;

typedef struct // structure for status window data
{ double obj,   // objective
         dobj;  // change in objective
  long cons;  // number of constraints
  int ywedge,  // width of top+bottom window borders
      xwedge, // width of left+right window borders
      ymax,  // required vertical client height
      xmax;   // required horizontal client width
} status_type;

typedef struct // structure holding child window location information
{ int p_on,  // 0 if there is no param window
      s_on,  // 0 if there is no status window
      n_uf,  // number of u.f. windows
      n_op,  // number of output windows
      param_w, // optimum param window width
      param_h, // optimum param window height 
      status_h[3], // optimal status window heights
      status_w[3], // optimal status window widths
      auto_arr; // set to 0 if user has arranged 
  RECT ref,   // parent client area size on last resize
       ploc,  // location of parameter window
       sloc,  // location of status window
       *ufloc,  // ufloc[i] is location of uf window i
       *oploc;  // oploc[i] is location of op window i
  HWND hstat; // status window handle
} child_location_type;

typedef struct  // structure designed to contain parent window data
{ int n_uf,  // number of uf's in model
      n_opw,  // number of graphical output windows
      *disvc, // disvc[i] returns the curve number for display variable i (given window)
      *disvw, // disvw[i] returns the window number for display variable i
      *fitvc, // fitvc[i] is curve in given window corresponding to fit variable in col i+1 of file
      *fitvw, // fitvw[i] is window containing data for fit variable in file col. i+1
      n_uc,    // number of unknown coefficients
      n_fit,   // number of variables to be fitted (or simulated)
      *ufdf,   // ufdf[i] is number of df's of ith u.f.
      n_disv,  // number of display variables   
      sim;     // indicator of whether simulating (1) or fitting (0)
  double simnoise, // noise level to add to simulation
         simdt,    // simulation timestep
         simt0,    // simulation start time
         simt1,    // simulation end time
         *ufxmax, // max realized value of uf argument i
         *ufxmin, // min realized value of uf argument i
         **ufx, // ufx[i] is array of x values for uf i
         **ufy; // ufy[i] is array of y values for uf i  
  HWND hwnd,   // handle of parent window itself
       *opw,   // handles of graphics windows
       *ufw,   // handles of uf windows
       paramw,  // handle of parameter window
       statusw; // handle of status window 
  char **wname; // ith graphics window is called wname[i] 
  child_location_type loc; // information on location and size of children
} parent_win_data_type;

typedef struct // structure for sending setup information to parent window at creation
{ int fitmethod, // default fitting method
      errors,   // specify mean variance relationship
      gcv_method, // default gcv_method
      bsr_reps, // bootstrap restarting replicates
      n_uf,    // number of unknown functions
      n_c,     // number of fixed coeffs
      n_s,     // number of state variables
      n_hv,    // number of history variables
      n_fit,   // number of variables to be fitted to data
      n_lag,   // number of lags per history variable
      n_sw,    // number of switches
      n_st,    // defualt number of rows of data to read. 0 => read all rows.
      stats,   // flags indicating default statistics to match
      hbsize,  // history buffer size
      *distos, // distos[i] stores state variable index of display variable i
      *fitdv,  // fitdv[i]==0 if no data for this display var, otherwise file column for data
      n_opw,   // number of state variable output windows
      *disvc,  // disvc[i] gives curve number for  this display variable
      n_uc,    // number of unknown coefficients
      *ufdf,   // ufdf[i] is number of parameters for ith uf
      *uftype, // uftype[i] contains flags defining type of ith uf
      *uctype, // uctype[i] contains flags defining type of ith uc
      *disvw,  // disvw[i] is window number for ith display variable
      *index,  // indewx[i] is the state variable for column i
      *stodis, // stodis[i] is display variable for ith state variable (-1 for none)
      n_disv;   // number of display variables
  double *uc,   // array of unknown coeff initial values
         **ufx, // ufx[i] is array of x values for uf i
         **ufy, // ufy[i] is array of y values for uf i  
         *ufsp, // default smoothing parameters for uf's any -ve => estimate
         *ufspmax, // upper limits on smoothing parameters, 0 => none
         *ufub, // upper bound if any on uf
         *uflb, // lower bound if any on uf
         *uclb, // lower bound on uc, if any
         *ucub, // upper bound on uc, if any
         *wstats, // weights for additional statistics
         *re_vmax, // re_vmax[i] is maximum variance of ith random effect
         *x0,   // x0[i] is lower x axis limit for graphic window i
         *x1,   // x1[i] is upper x axis limit for graphic window i
         *y0,   // y0[i] is lower y axis limit for graphic window i
         *y1,   // y1[i] is upper y axis limit for graphic window i
         *c,    // c[] is array of fixed model coeffs. 
          dt,   // initial timestep
          dout, // approximate output timestep
          t0,   // integration start time (not data start time)
         tol;   // integration tolerance
  char *dfile,  // default data file name
       *wfile,  // default weight file name
       **wname, // ith graphics window is called wname[i]      
       **cname, // cname[i] is name of uc(i)
       **label; // label[i] is label for display variable i
} parent_setup_type;

typedef struct   // structure containing data for parameter window
{ int nc,    // number of parameters
      rows,  // rows for dsiplay
      cols,  // cols for display
      ywedge, // vertical width of top+bottom window border 
      xwedge, // horizontal width of left+right window border
      editing, // is set to 1 if editing allowed, otherwise 0
      xmax,    // required horizontal client width to fit in all parameters
      ymax,    // required vertical client height to fit all parameters
      cxchar,  // typical character width
      cychar,  // typical character height
      height,  // row height
      space,   // columns spacing
      y0,      // current y position at which top left of display area is <=0
      x0,      // current x position at which top left of display area is <=0
      VSmax,   // Vertical scroll bar extent
      HSmax;   // horizontal scroll bar extent
  
  double *c;   // the parameters 
  char **cname; // cname[i] is the name of parameter i.
  SIZE wsize;   // used for storing edit window sizes
  HWND *hew;    // handles to edit windows
  HFONT hFont; // handle to the font used in the window and edit windows
} param_win_data_type;


typedef struct
{ int nc;
  double *c;
  char **cname;
} param_setup_type;


/*void error(char *str);
void output(double *s,double t);*/
void outputthread(void);
void initcons(int *no_cons, int *no_vars);
void setscale(double min,double max,double dx,int *n,double *lo,double *hi);
void scale(double min,double max, double *x0,double *dx,int *nx,double *exx);
void tplot(HDC hdc,HWND hwnd, winplotype *w, int draw);
LRESULT CALLBACK ParentWndProc (HWND,UINT,WPARAM,LPARAM);
void workthread(PVOID pvoid);
void compressbuffer(winplotype *w);
void setupglobaldata(ddefit_control dfc);
int WarningQuery(char *msg);

